
/* Chrysalide - Outil d'analyse de fichiers binaires
 * arm_opcodes.h - prototypes pour la traduction d'instructions ARMv7
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_ARM_V7_OPCODES_ARM_OPCODES_H
#define _PLUGINS_ARM_V7_OPCODES_ARM_OPCODES_H


#include <stdint.h> 
 
#include <arch/instruction.h>



/* Décode une instruction de type 'adc'. */
GArchInstruction *armv7_read_arm_instr_a8_adc_immediate(uint32_t raw);

/* Décode une instruction de type 'adc'. */
GArchInstruction *armv7_read_arm_instr_a8_adc_register(uint32_t raw);

/* Décode une instruction de type 'adc'. */
GArchInstruction *armv7_read_arm_instr_a8_adc_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'add'. */
GArchInstruction *armv7_read_arm_instr_a8_add_immediate_arm(uint32_t raw);

/* Décode une instruction de type 'add'. */
GArchInstruction *armv7_read_arm_instr_a8_add_register_arm(uint32_t raw);

/* Décode une instruction de type 'add'. */
GArchInstruction *armv7_read_arm_instr_a8_add_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'add'. */
GArchInstruction *armv7_read_arm_instr_a8_add_sp_plus_immediate(uint32_t raw);

/* Décode une instruction de type 'add'. */
GArchInstruction *armv7_read_arm_instr_a8_add_sp_plus_register_arm(uint32_t raw);

/* Décode une instruction de type 'adr'. */
GArchInstruction *armv7_read_arm_instr_a8_adr(uint32_t raw);

/* Décode une instruction de type 'and'. */
GArchInstruction *armv7_read_arm_instr_a8_and_immediate(uint32_t raw);

/* Décode une instruction de type 'and'. */
GArchInstruction *armv7_read_arm_instr_a8_and_register(uint32_t raw);

/* Décode une instruction de type 'and'. */
GArchInstruction *armv7_read_arm_instr_a8_and_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'asr'. */
GArchInstruction *armv7_read_arm_instr_a8_asr_immediate(uint32_t raw);

/* Décode une instruction de type 'asr'. */
GArchInstruction *armv7_read_arm_instr_a8_asr_register(uint32_t raw);

/* Décode une instruction de type 'b'. */
GArchInstruction *armv7_read_arm_instr_a8_b(uint32_t raw);

/* Décode une instruction de type 'bfc'. */
GArchInstruction *armv7_read_arm_instr_a8_bfc(uint32_t raw);

/* Décode une instruction de type 'bfi'. */
GArchInstruction *armv7_read_arm_instr_a8_bfi(uint32_t raw);

/* Décode une instruction de type 'bic'. */
GArchInstruction *armv7_read_arm_instr_a8_bic_immediate(uint32_t raw);

/* Décode une instruction de type 'bic'. */
GArchInstruction *armv7_read_arm_instr_a8_bic_register(uint32_t raw);

/* Décode une instruction de type 'bic'. */
GArchInstruction *armv7_read_arm_instr_a8_bic_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'bkpt'. */
GArchInstruction *armv7_read_arm_instr_a8_bkpt(uint32_t raw);

/* Décode une instruction de type 'bl'. */
GArchInstruction *armv7_read_arm_instr_a8_bl_blx_immediate(uint32_t raw);

/* Décode une instruction de type 'blx'. */
GArchInstruction *armv7_read_arm_instr_a8_blx_register(uint32_t raw);

/* Décode une instruction de type 'bx'. */
GArchInstruction *armv7_read_arm_instr_a8_bx(uint32_t raw);

/* Décode une instruction de type 'bxj'. */
GArchInstruction *armv7_read_arm_instr_a8_bxj(uint32_t raw);

/* Décode une instruction de type 'cdp'. */
GArchInstruction *armv7_read_arm_instr_a8_cdp_cdp2(uint32_t raw);

/* Décode une instruction de type 'clrex'. */
GArchInstruction *armv7_read_arm_instr_a8_clrex(uint32_t raw);

/* Décode une instruction de type 'clz'. */
GArchInstruction *armv7_read_arm_instr_a8_clz(uint32_t raw);

/* Décode une instruction de type 'cmn'. */
GArchInstruction *armv7_read_arm_instr_a8_cmn_immediate(uint32_t raw);

/* Décode une instruction de type 'cmn'. */
GArchInstruction *armv7_read_arm_instr_a8_cmn_register(uint32_t raw);

/* Décode une instruction de type 'cmn'. */
GArchInstruction *armv7_read_arm_instr_a8_cmn_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'cmp'. */
GArchInstruction *armv7_read_arm_instr_a8_cmp_immediate(uint32_t raw);

/* Décode une instruction de type 'cmp'. */
GArchInstruction *armv7_read_arm_instr_a8_cmp_register(uint32_t raw);

/* Décode une instruction de type 'cmp'. */
GArchInstruction *armv7_read_arm_instr_a8_cmp_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'dbg'. */
GArchInstruction *armv7_read_arm_instr_a8_dbg(uint32_t raw);

/* Décode une instruction de type 'dmb'. */
GArchInstruction *armv7_read_arm_instr_a8_dmb(uint32_t raw);

/* Décode une instruction de type 'dsb'. */
GArchInstruction *armv7_read_arm_instr_a8_dsb(uint32_t raw);

/* Décode une instruction de type 'eor'. */
GArchInstruction *armv7_read_arm_instr_a8_eor_immediate(uint32_t raw);

/* Décode une instruction de type 'eor'. */
GArchInstruction *armv7_read_arm_instr_a8_eor_register(uint32_t raw);

/* Décode une instruction de type 'eor'. */
GArchInstruction *armv7_read_arm_instr_a8_eor_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'isb'. */
GArchInstruction *armv7_read_arm_instr_a8_isb(uint32_t raw);

/* Décode une instruction de type 'ldc'. */
GArchInstruction *armv7_read_arm_instr_a8_ldc_ldc2_immediate(uint32_t raw);

/* Décode une instruction de type 'ldc'. */
GArchInstruction *armv7_read_arm_instr_a8_ldc_ldc2_literal(uint32_t raw);

/* Décode une instruction de type 'ldm'. */
GArchInstruction *armv7_read_arm_instr_a8_ldm_ldmia_ldmfd_arm(uint32_t raw);

/* Décode une instruction de type 'ldmda'. */
GArchInstruction *armv7_read_arm_instr_a8_ldmda_ldmfa(uint32_t raw);

/* Décode une instruction de type 'ldmdb'. */
GArchInstruction *armv7_read_arm_instr_a8_ldmdb_ldmea(uint32_t raw);

/* Décode une instruction de type 'ldmib'. */
GArchInstruction *armv7_read_arm_instr_a8_ldmib_ldmed(uint32_t raw);

/* Décode une instruction de type 'ldr'. */
GArchInstruction *armv7_read_arm_instr_a8_ldr_immediate_arm(uint32_t raw);

/* Décode une instruction de type 'ldr'. */
GArchInstruction *armv7_read_arm_instr_a8_ldr_literal(uint32_t raw);

/* Décode une instruction de type 'ldr'. */
GArchInstruction *armv7_read_arm_instr_a8_ldr_register_arm(uint32_t raw);

/* Décode une instruction de type 'ldrb'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrb_immediate_arm(uint32_t raw);

/* Décode une instruction de type 'ldrb'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrb_literal(uint32_t raw);

/* Décode une instruction de type 'ldrb'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrb_register(uint32_t raw);

/* Décode une instruction de type 'ldrbt'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrbt(uint32_t raw);

/* Décode une instruction de type 'ldrd'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrd_immediate(uint32_t raw);

/* Décode une instruction de type 'ldrd'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrd_literal(uint32_t raw);

/* Décode une instruction de type 'ldrd'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrd_register(uint32_t raw);

/* Décode une instruction de type 'ldrex'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrex(uint32_t raw);

/* Décode une instruction de type 'ldrexb'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrexb(uint32_t raw);

/* Décode une instruction de type 'ldrexd'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrexd(uint32_t raw);

/* Décode une instruction de type 'ldrexh'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrexh(uint32_t raw);

/* Décode une instruction de type 'ldrh'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrh_immediate_arm(uint32_t raw);

/* Décode une instruction de type 'ldrh'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrh_literal(uint32_t raw);

/* Décode une instruction de type 'ldrh'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrh_register(uint32_t raw);

/* Décode une instruction de type 'ldrht'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrht(uint32_t raw);

/* Décode une instruction de type 'ldrsb'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrsb_immediate(uint32_t raw);

/* Décode une instruction de type 'ldrsb'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrsb_literal(uint32_t raw);

/* Décode une instruction de type 'ldrsb'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrsb_register(uint32_t raw);

/* Décode une instruction de type 'ldrsbt'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrsbt(uint32_t raw);

/* Décode une instruction de type 'ldrsh'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrsh_immediate(uint32_t raw);

/* Décode une instruction de type 'ldrsh'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrsh_literal(uint32_t raw);

/* Décode une instruction de type 'ldrsh'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrsh_register(uint32_t raw);

/* Décode une instruction de type 'ldrsht'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrsht(uint32_t raw);

/* Décode une instruction de type 'ldrt'. */
GArchInstruction *armv7_read_arm_instr_a8_ldrt(uint32_t raw);

/* Décode une instruction de type 'lsl'. */
GArchInstruction *armv7_read_arm_instr_a8_lsl_immediate(uint32_t raw);

/* Décode une instruction de type 'lsl'. */
GArchInstruction *armv7_read_arm_instr_a8_lsl_register(uint32_t raw);

/* Décode une instruction de type 'lsr'. */
GArchInstruction *armv7_read_arm_instr_a8_lsr_immediate(uint32_t raw);

/* Décode une instruction de type 'lsr'. */
GArchInstruction *armv7_read_arm_instr_a8_lsr_register(uint32_t raw);

/* Décode une instruction de type 'mcr'. */
GArchInstruction *armv7_read_arm_instr_a8_mcr_mcr2(uint32_t raw);

/* Décode une instruction de type 'mcrr'. */
GArchInstruction *armv7_read_arm_instr_a8_mcrr_mcrr2(uint32_t raw);

/* Décode une instruction de type 'mla'. */
GArchInstruction *armv7_read_arm_instr_a8_mla(uint32_t raw);

/* Décode une instruction de type 'mls'. */
GArchInstruction *armv7_read_arm_instr_a8_mls(uint32_t raw);

/* Décode une instruction de type 'mov'. */
GArchInstruction *armv7_read_arm_instr_a8_mov_immediate(uint32_t raw);

/* Décode une instruction de type 'mov'. */
GArchInstruction *armv7_read_arm_instr_a8_mov_register_arm(uint32_t raw);

/* Décode une instruction de type 'movt'. */
GArchInstruction *armv7_read_arm_instr_a8_movt(uint32_t raw);

/* Décode une instruction de type 'mrc'. */
GArchInstruction *armv7_read_arm_instr_a8_mrc_mrc2(uint32_t raw);

/* Décode une instruction de type 'mrrc'. */
GArchInstruction *armv7_read_arm_instr_a8_mrrc_mrrc2(uint32_t raw);

/* Décode une instruction de type 'mrs'. */
GArchInstruction *armv7_read_arm_instr_a8_mrs(uint32_t raw);

/* Décode une instruction de type 'msr'. */
GArchInstruction *armv7_read_arm_instr_a8_msr_immediate(uint32_t raw);

/* Décode une instruction de type 'msr'. */
GArchInstruction *armv7_read_arm_instr_a8_msr_register(uint32_t raw);

/* Décode une instruction de type 'mul'. */
GArchInstruction *armv7_read_arm_instr_a8_mul(uint32_t raw);

/* Décode une instruction de type 'mvn'. */
GArchInstruction *armv7_read_arm_instr_a8_mvn_immediate(uint32_t raw);

/* Décode une instruction de type 'mvn'. */
GArchInstruction *armv7_read_arm_instr_a8_mvn_register(uint32_t raw);

/* Décode une instruction de type 'mvn'. */
GArchInstruction *armv7_read_arm_instr_a8_mvn_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'nop'. */
GArchInstruction *armv7_read_arm_instr_a8_nop(uint32_t raw);

/* Décode une instruction de type 'orr'. */
GArchInstruction *armv7_read_arm_instr_a8_orr_immediate(uint32_t raw);

/* Décode une instruction de type 'orr'. */
GArchInstruction *armv7_read_arm_instr_a8_orr_register(uint32_t raw);

/* Décode une instruction de type 'orr'. */
GArchInstruction *armv7_read_arm_instr_a8_orr_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'pkh'. */
GArchInstruction *armv7_read_arm_instr_a8_pkh(uint32_t raw);

/* Décode une instruction de type 'pld'. */
GArchInstruction *armv7_read_arm_instr_a8_pld_pldw_immediate(uint32_t raw);

/* Décode une instruction de type 'pld'. */
GArchInstruction *armv7_read_arm_instr_a8_pld_literal(uint32_t raw);

/* Décode une instruction de type 'pld'. */
GArchInstruction *armv7_read_arm_instr_a8_pld_pldw_register(uint32_t raw);

/* Décode une instruction de type 'pli'. */
GArchInstruction *armv7_read_arm_instr_a8_pli_immediate_literal(uint32_t raw);

/* Décode une instruction de type 'pli'. */
GArchInstruction *armv7_read_arm_instr_a8_pli_register(uint32_t raw);

/* Décode une instruction de type 'pop'. */
GArchInstruction *armv7_read_arm_instr_a8_pop_arm(uint32_t raw);

/* Décode une instruction de type 'push'. */
GArchInstruction *armv7_read_arm_instr_a8_push(uint32_t raw);

/* Décode une instruction de type 'qadd'. */
GArchInstruction *armv7_read_arm_instr_a8_qadd(uint32_t raw);

/* Décode une instruction de type 'qadd16'. */
GArchInstruction *armv7_read_arm_instr_a8_qadd16(uint32_t raw);

/* Décode une instruction de type 'qadd8'. */
GArchInstruction *armv7_read_arm_instr_a8_qadd8(uint32_t raw);

/* Décode une instruction de type 'qasx'. */
GArchInstruction *armv7_read_arm_instr_a8_qasx(uint32_t raw);

/* Décode une instruction de type 'qdadd'. */
GArchInstruction *armv7_read_arm_instr_a8_qdadd(uint32_t raw);

/* Décode une instruction de type 'qdsub'. */
GArchInstruction *armv7_read_arm_instr_a8_qdsub(uint32_t raw);

/* Décode une instruction de type 'qsax'. */
GArchInstruction *armv7_read_arm_instr_a8_qsax(uint32_t raw);

/* Décode une instruction de type 'qsub'. */
GArchInstruction *armv7_read_arm_instr_a8_qsub(uint32_t raw);

/* Décode une instruction de type 'qsub16'. */
GArchInstruction *armv7_read_arm_instr_a8_qsub16(uint32_t raw);

/* Décode une instruction de type 'qsub8'. */
GArchInstruction *armv7_read_arm_instr_a8_qsub8(uint32_t raw);

/* Décode une instruction de type 'rbit'. */
GArchInstruction *armv7_read_arm_instr_a8_rbit(uint32_t raw);

/* Décode une instruction de type 'rev'. */
GArchInstruction *armv7_read_arm_instr_a8_rev(uint32_t raw);

/* Décode une instruction de type 'rev16'. */
GArchInstruction *armv7_read_arm_instr_a8_rev16(uint32_t raw);

/* Décode une instruction de type 'revsh'. */
GArchInstruction *armv7_read_arm_instr_a8_revsh(uint32_t raw);

/* Décode une instruction de type 'ror'. */
GArchInstruction *armv7_read_arm_instr_a8_ror_immediate(uint32_t raw);

/* Décode une instruction de type 'ror'. */
GArchInstruction *armv7_read_arm_instr_a8_ror_register(uint32_t raw);

/* Décode une instruction de type 'rrx'. */
GArchInstruction *armv7_read_arm_instr_a8_rrx(uint32_t raw);

/* Décode une instruction de type 'rsb'. */
GArchInstruction *armv7_read_arm_instr_a8_rsb_immediate(uint32_t raw);

/* Décode une instruction de type 'rsb'. */
GArchInstruction *armv7_read_arm_instr_a8_rsb_register(uint32_t raw);

/* Décode une instruction de type 'rsb'. */
GArchInstruction *armv7_read_arm_instr_a8_rsb_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'rsc'. */
GArchInstruction *armv7_read_arm_instr_a8_rsc_immediate(uint32_t raw);

/* Décode une instruction de type 'rsc'. */
GArchInstruction *armv7_read_arm_instr_a8_rsc_register(uint32_t raw);

/* Décode une instruction de type 'rsc'. */
GArchInstruction *armv7_read_arm_instr_a8_rsc_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'sadd16'. */
GArchInstruction *armv7_read_arm_instr_a8_sadd16(uint32_t raw);

/* Décode une instruction de type 'sadd8'. */
GArchInstruction *armv7_read_arm_instr_a8_sadd8(uint32_t raw);

/* Décode une instruction de type 'sasx'. */
GArchInstruction *armv7_read_arm_instr_a8_sasx(uint32_t raw);

/* Décode une instruction de type 'sbc'. */
GArchInstruction *armv7_read_arm_instr_a8_sbc_immediate(uint32_t raw);

/* Décode une instruction de type 'sbc'. */
GArchInstruction *armv7_read_arm_instr_a8_sbc_register(uint32_t raw);

/* Décode une instruction de type 'sbc'. */
GArchInstruction *armv7_read_arm_instr_a8_sbc_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'sbfx'. */
GArchInstruction *armv7_read_arm_instr_a8_sbfx(uint32_t raw);

/* Décode une instruction de type 'sdiv'. */
GArchInstruction *armv7_read_arm_instr_a8_sdiv(uint32_t raw);

/* Décode une instruction de type 'sel'. */
GArchInstruction *armv7_read_arm_instr_a8_sel(uint32_t raw);

/* Décode une instruction de type 'setend'. */
GArchInstruction *armv7_read_arm_instr_a8_setend(uint32_t raw);

/* Décode une instruction de type 'sev'. */
GArchInstruction *armv7_read_arm_instr_a8_sev(uint32_t raw);

/* Décode une instruction de type 'shadd16'. */
GArchInstruction *armv7_read_arm_instr_a8_shadd16(uint32_t raw);

/* Décode une instruction de type 'shadd8'. */
GArchInstruction *armv7_read_arm_instr_a8_shadd8(uint32_t raw);

/* Décode une instruction de type 'shasx'. */
GArchInstruction *armv7_read_arm_instr_a8_shasx(uint32_t raw);

/* Décode une instruction de type 'shsax'. */
GArchInstruction *armv7_read_arm_instr_a8_shsax(uint32_t raw);

/* Décode une instruction de type 'shsub16'. */
GArchInstruction *armv7_read_arm_instr_a8_shsub16(uint32_t raw);

/* Décode une instruction de type 'shsub8'. */
GArchInstruction *armv7_read_arm_instr_a8_shsub8(uint32_t raw);

/* Décode une instruction de type 'smlabb'. */
GArchInstruction *armv7_read_arm_instr_a8_smlabb_smlabt_smlatb_smlatt(uint32_t raw);

/* Décode une instruction de type 'smlad'. */
GArchInstruction *armv7_read_arm_instr_a8_smlad(uint32_t raw);

/* Décode une instruction de type 'smlal'. */
GArchInstruction *armv7_read_arm_instr_a8_smlal(uint32_t raw);

/* Décode une instruction de type 'smlalbb'. */
GArchInstruction *armv7_read_arm_instr_a8_smlalbb_smlalbt_smlaltb_smlaltt(uint32_t raw);

/* Décode une instruction de type 'smlald'. */
GArchInstruction *armv7_read_arm_instr_a8_smlald(uint32_t raw);

/* Décode une instruction de type 'smlawb'. */
GArchInstruction *armv7_read_arm_instr_a8_smlawb_smlawt(uint32_t raw);

/* Décode une instruction de type 'smlsd'. */
GArchInstruction *armv7_read_arm_instr_a8_smlsd(uint32_t raw);

/* Décode une instruction de type 'smlsld'. */
GArchInstruction *armv7_read_arm_instr_a8_smlsld(uint32_t raw);

/* Décode une instruction de type 'smmla'. */
GArchInstruction *armv7_read_arm_instr_a8_smmla(uint32_t raw);

/* Décode une instruction de type 'smmls'. */
GArchInstruction *armv7_read_arm_instr_a8_smmls(uint32_t raw);

/* Décode une instruction de type 'smmul'. */
GArchInstruction *armv7_read_arm_instr_a8_smmul(uint32_t raw);

/* Décode une instruction de type 'smuad'. */
GArchInstruction *armv7_read_arm_instr_a8_smuad(uint32_t raw);

/* Décode une instruction de type 'smulbb'. */
GArchInstruction *armv7_read_arm_instr_a8_smulbb_smulbt_smultb_smultt(uint32_t raw);

/* Décode une instruction de type 'smull'. */
GArchInstruction *armv7_read_arm_instr_a8_smull(uint32_t raw);

/* Décode une instruction de type 'smulwb'. */
GArchInstruction *armv7_read_arm_instr_a8_smulwb_smulwt(uint32_t raw);

/* Décode une instruction de type 'smusd'. */
GArchInstruction *armv7_read_arm_instr_a8_smusd(uint32_t raw);

/* Décode une instruction de type 'ssat'. */
GArchInstruction *armv7_read_arm_instr_a8_ssat(uint32_t raw);

/* Décode une instruction de type 'ssat16'. */
GArchInstruction *armv7_read_arm_instr_a8_ssat16(uint32_t raw);

/* Décode une instruction de type 'ssax'. */
GArchInstruction *armv7_read_arm_instr_a8_ssax(uint32_t raw);

/* Décode une instruction de type 'ssub16'. */
GArchInstruction *armv7_read_arm_instr_a8_ssub16(uint32_t raw);

/* Décode une instruction de type 'ssub8'. */
GArchInstruction *armv7_read_arm_instr_a8_ssub8(uint32_t raw);

/* Décode une instruction de type 'stc'. */
GArchInstruction *armv7_read_arm_instr_a8_stc_stc2(uint32_t raw);

/* Décode une instruction de type 'stm'. */
GArchInstruction *armv7_read_arm_instr_a8_stm_stmia_stmea(uint32_t raw);

/* Décode une instruction de type 'stmda'. */
GArchInstruction *armv7_read_arm_instr_a8_stmda_stmed(uint32_t raw);

/* Décode une instruction de type 'stmdb'. */
GArchInstruction *armv7_read_arm_instr_a8_stmdb_stmfd(uint32_t raw);

/* Décode une instruction de type 'stmib'. */
GArchInstruction *armv7_read_arm_instr_a8_stmib_stmfa(uint32_t raw);

/* Décode une instruction de type 'str'. */
GArchInstruction *armv7_read_arm_instr_a8_str_immediate_arm(uint32_t raw);

/* Décode une instruction de type 'str'. */
GArchInstruction *armv7_read_arm_instr_a8_str_register(uint32_t raw);

/* Décode une instruction de type 'strb'. */
GArchInstruction *armv7_read_arm_instr_a8_strb_immediate_arm(uint32_t raw);

/* Décode une instruction de type 'strb'. */
GArchInstruction *armv7_read_arm_instr_a8_strb_register(uint32_t raw);

/* Décode une instruction de type 'strbt'. */
GArchInstruction *armv7_read_arm_instr_a8_strbt(uint32_t raw);

/* Décode une instruction de type 'strd'. */
GArchInstruction *armv7_read_arm_instr_a8_strd_immediate(uint32_t raw);

/* Décode une instruction de type 'strd'. */
GArchInstruction *armv7_read_arm_instr_a8_strd_register(uint32_t raw);

/* Décode une instruction de type 'strex'. */
GArchInstruction *armv7_read_arm_instr_a8_strex(uint32_t raw);

/* Décode une instruction de type 'strexb'. */
GArchInstruction *armv7_read_arm_instr_a8_strexb(uint32_t raw);

/* Décode une instruction de type 'strexd'. */
GArchInstruction *armv7_read_arm_instr_a8_strexd(uint32_t raw);

/* Décode une instruction de type 'strexh'. */
GArchInstruction *armv7_read_arm_instr_a8_strexh(uint32_t raw);

/* Décode une instruction de type 'strh'. */
GArchInstruction *armv7_read_arm_instr_a8_strh_immediate_arm(uint32_t raw);

/* Décode une instruction de type 'strh'. */
GArchInstruction *armv7_read_arm_instr_a8_strh_register(uint32_t raw);

/* Décode une instruction de type 'strht'. */
GArchInstruction *armv7_read_arm_instr_a8_strht(uint32_t raw);

/* Décode une instruction de type 'strt'. */
GArchInstruction *armv7_read_arm_instr_a8_strt(uint32_t raw);

/* Décode une instruction de type 'sub'. */
GArchInstruction *armv7_read_arm_instr_a8_sub_immediate_arm(uint32_t raw);

/* Décode une instruction de type 'sub'. */
GArchInstruction *armv7_read_arm_instr_a8_sub_register(uint32_t raw);

/* Décode une instruction de type 'sub'. */
GArchInstruction *armv7_read_arm_instr_a8_sub_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'sub'. */
GArchInstruction *armv7_read_arm_instr_a8_sub_sp_minus_immediate(uint32_t raw);

/* Décode une instruction de type 'sub'. */
GArchInstruction *armv7_read_arm_instr_a8_sub_sp_minus_register(uint32_t raw);

/* Décode une instruction de type 'svc'. */
GArchInstruction *armv7_read_arm_instr_a8_svc_previously_swi(uint32_t raw);

/* Décode une instruction de type 'swp'. */
GArchInstruction *armv7_read_arm_instr_a8_swp_swpb(uint32_t raw);

/* Décode une instruction de type 'sxtab'. */
GArchInstruction *armv7_read_arm_instr_a8_sxtab(uint32_t raw);

/* Décode une instruction de type 'sxtab16'. */
GArchInstruction *armv7_read_arm_instr_a8_sxtab16(uint32_t raw);

/* Décode une instruction de type 'sxtah'. */
GArchInstruction *armv7_read_arm_instr_a8_sxtah(uint32_t raw);

/* Décode une instruction de type 'sxtb'. */
GArchInstruction *armv7_read_arm_instr_a8_sxtb(uint32_t raw);

/* Décode une instruction de type 'sxtb16'. */
GArchInstruction *armv7_read_arm_instr_a8_sxtb16(uint32_t raw);

/* Décode une instruction de type 'sxth'. */
GArchInstruction *armv7_read_arm_instr_a8_sxth(uint32_t raw);

/* Décode une instruction de type 'teq'. */
GArchInstruction *armv7_read_arm_instr_a8_teq_immediate(uint32_t raw);

/* Décode une instruction de type 'teq'. */
GArchInstruction *armv7_read_arm_instr_a8_teq_register(uint32_t raw);

/* Décode une instruction de type 'teq'. */
GArchInstruction *armv7_read_arm_instr_a8_teq_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'tst'. */
GArchInstruction *armv7_read_arm_instr_a8_tst_immediate(uint32_t raw);

/* Décode une instruction de type 'tst'. */
GArchInstruction *armv7_read_arm_instr_a8_tst_register(uint32_t raw);

/* Décode une instruction de type 'tst'. */
GArchInstruction *armv7_read_arm_instr_a8_tst_register_shifted_register(uint32_t raw);

/* Décode une instruction de type 'uadd16'. */
GArchInstruction *armv7_read_arm_instr_a8_uadd16(uint32_t raw);

/* Décode une instruction de type 'uadd8'. */
GArchInstruction *armv7_read_arm_instr_a8_uadd8(uint32_t raw);

/* Décode une instruction de type 'uasx'. */
GArchInstruction *armv7_read_arm_instr_a8_uasx(uint32_t raw);

/* Décode une instruction de type 'ubfx'. */
GArchInstruction *armv7_read_arm_instr_a8_ubfx(uint32_t raw);

/* Décode une instruction de type 'udf'. */
GArchInstruction *armv7_read_arm_instr_a8_udf(uint32_t raw);

/* Décode une instruction de type 'udiv'. */
GArchInstruction *armv7_read_arm_instr_a8_udiv(uint32_t raw);

/* Décode une instruction de type 'uhadd16'. */
GArchInstruction *armv7_read_arm_instr_a8_uhadd16(uint32_t raw);

/* Décode une instruction de type 'uhadd8'. */
GArchInstruction *armv7_read_arm_instr_a8_uhadd8(uint32_t raw);

/* Décode une instruction de type 'uhasx'. */
GArchInstruction *armv7_read_arm_instr_a8_uhasx(uint32_t raw);

/* Décode une instruction de type 'uhsax'. */
GArchInstruction *armv7_read_arm_instr_a8_uhsax(uint32_t raw);

/* Décode une instruction de type 'uhsub16'. */
GArchInstruction *armv7_read_arm_instr_a8_uhsub16(uint32_t raw);

/* Décode une instruction de type 'uhsub8'. */
GArchInstruction *armv7_read_arm_instr_a8_uhsub8(uint32_t raw);

/* Décode une instruction de type 'umaal'. */
GArchInstruction *armv7_read_arm_instr_a8_umaal(uint32_t raw);

/* Décode une instruction de type 'umlal'. */
GArchInstruction *armv7_read_arm_instr_a8_umlal(uint32_t raw);

/* Décode une instruction de type 'umull'. */
GArchInstruction *armv7_read_arm_instr_a8_umull(uint32_t raw);

/* Décode une instruction de type 'uqadd16'. */
GArchInstruction *armv7_read_arm_instr_a8_uqadd16(uint32_t raw);

/* Décode une instruction de type 'uqadd8'. */
GArchInstruction *armv7_read_arm_instr_a8_uqadd8(uint32_t raw);

/* Décode une instruction de type 'uqasx'. */
GArchInstruction *armv7_read_arm_instr_a8_uqasx(uint32_t raw);

/* Décode une instruction de type 'uqsax'. */
GArchInstruction *armv7_read_arm_instr_a8_uqsax(uint32_t raw);

/* Décode une instruction de type 'uqsub16'. */
GArchInstruction *armv7_read_arm_instr_a8_uqsub16(uint32_t raw);

/* Décode une instruction de type 'uqsub8'. */
GArchInstruction *armv7_read_arm_instr_a8_uqsub8(uint32_t raw);

/* Décode une instruction de type 'usad8'. */
GArchInstruction *armv7_read_arm_instr_a8_usad8(uint32_t raw);

/* Décode une instruction de type 'usada8'. */
GArchInstruction *armv7_read_arm_instr_a8_usada8(uint32_t raw);

/* Décode une instruction de type 'usat'. */
GArchInstruction *armv7_read_arm_instr_a8_usat(uint32_t raw);

/* Décode une instruction de type 'usat16'. */
GArchInstruction *armv7_read_arm_instr_a8_usat16(uint32_t raw);

/* Décode une instruction de type 'usax'. */
GArchInstruction *armv7_read_arm_instr_a8_usax(uint32_t raw);

/* Décode une instruction de type 'usub16'. */
GArchInstruction *armv7_read_arm_instr_a8_usub16(uint32_t raw);

/* Décode une instruction de type 'usub8'. */
GArchInstruction *armv7_read_arm_instr_a8_usub8(uint32_t raw);

/* Décode une instruction de type 'uxtab'. */
GArchInstruction *armv7_read_arm_instr_a8_uxtab(uint32_t raw);

/* Décode une instruction de type 'uxtab16'. */
GArchInstruction *armv7_read_arm_instr_a8_uxtab16(uint32_t raw);

/* Décode une instruction de type 'uxtah'. */
GArchInstruction *armv7_read_arm_instr_a8_uxtah(uint32_t raw);

/* Décode une instruction de type 'uxtb'. */
GArchInstruction *armv7_read_arm_instr_a8_uxtb(uint32_t raw);

/* Décode une instruction de type 'uxtb16'. */
GArchInstruction *armv7_read_arm_instr_a8_uxtb16(uint32_t raw);

/* Décode une instruction de type 'uxth'. */
GArchInstruction *armv7_read_arm_instr_a8_uxth(uint32_t raw);

/* Décode une instruction de type 'vaba'. */
GArchInstruction *armv7_read_arm_instr_a8_vaba_vabal(uint32_t raw);

/* Décode une instruction de type 'vabd'. */
GArchInstruction *armv7_read_arm_instr_a8_vabd_vabdl_integer(uint32_t raw);

/* Décode une instruction de type 'vabd'. */
GArchInstruction *armv7_read_arm_instr_a8_vabd_floating_point(uint32_t raw);

/* Décode une instruction de type 'vabs'. */
GArchInstruction *armv7_read_arm_instr_a8_vabs(uint32_t raw);

/* Décode une instruction de type 'vacge'. */
GArchInstruction *armv7_read_arm_instr_a8_vacge_vacgt_vacle_vaclt(uint32_t raw);

/* Décode une instruction de type 'vadd'. */
GArchInstruction *armv7_read_arm_instr_a8_vadd_integer(uint32_t raw);

/* Décode une instruction de type 'vadd'. */
GArchInstruction *armv7_read_arm_instr_a8_vadd_floating_point(uint32_t raw);

/* Décode une instruction de type 'vaddhn'. */
GArchInstruction *armv7_read_arm_instr_a8_vaddhn(uint32_t raw);

/* Décode une instruction de type 'vaddl'. */
GArchInstruction *armv7_read_arm_instr_a8_vaddl_vaddw(uint32_t raw);

/* Décode une instruction de type 'vand'. */
GArchInstruction *armv7_read_arm_instr_a8_vand_register(uint32_t raw);

/* Décode une instruction de type 'vbic'. */
GArchInstruction *armv7_read_arm_instr_a8_vbic_immediate(uint32_t raw);

/* Décode une instruction de type 'vbic'. */
GArchInstruction *armv7_read_arm_instr_a8_vbic_register(uint32_t raw);

/* Décode une instruction de type 'vbif'. */
GArchInstruction *armv7_read_arm_instr_a8_vbif_vbit_vbsl(uint32_t raw);

/* Décode une instruction de type 'vceq'. */
GArchInstruction *armv7_read_arm_instr_a8_vceq_register(uint32_t raw);

/* Décode une instruction de type 'vceq'. */
GArchInstruction *armv7_read_arm_instr_a8_vceq_immediate_0(uint32_t raw);

/* Décode une instruction de type 'vcge'. */
GArchInstruction *armv7_read_arm_instr_a8_vcge_register(uint32_t raw);

/* Décode une instruction de type 'vcge'. */
GArchInstruction *armv7_read_arm_instr_a8_vcge_immediate_0(uint32_t raw);

/* Décode une instruction de type 'vcgt'. */
GArchInstruction *armv7_read_arm_instr_a8_vcgt_register(uint32_t raw);

/* Décode une instruction de type 'vcgt'. */
GArchInstruction *armv7_read_arm_instr_a8_vcgt_immediate_0(uint32_t raw);

/* Décode une instruction de type 'vcle'. */
GArchInstruction *armv7_read_arm_instr_a8_vcle_immediate_0(uint32_t raw);

/* Décode une instruction de type 'vcls'. */
GArchInstruction *armv7_read_arm_instr_a8_vcls(uint32_t raw);

/* Décode une instruction de type 'vclt'. */
GArchInstruction *armv7_read_arm_instr_a8_vclt_immediate_0(uint32_t raw);

/* Décode une instruction de type 'vclz'. */
GArchInstruction *armv7_read_arm_instr_a8_vclz(uint32_t raw);

/* Décode une instruction de type 'vcmp'. */
GArchInstruction *armv7_read_arm_instr_a8_vcmp_vcmpe(uint32_t raw);

/* Décode une instruction de type 'vcnt'. */
GArchInstruction *armv7_read_arm_instr_a8_vcnt(uint32_t raw);

/* Décode une instruction de type 'vcvt'. */
GArchInstruction *armv7_read_arm_instr_a8_vcvt_between_floating_point_and_integer_advanced_simd(uint32_t raw);

/* Décode une instruction de type 'vcvt'. */
GArchInstruction *armv7_read_arm_instr_a8_vcvt_vcvtr_between_floating_point_and_integer_floating_point(uint32_t raw);

/* Décode une instruction de type 'vcvt'. */
GArchInstruction *armv7_read_arm_instr_a8_vcvt_between_double_precision_and_single_precision(uint32_t raw);

/* Décode une instruction de type 'vcvt'. */
GArchInstruction *armv7_read_arm_instr_a8_vcvt_between_half_precision_and_single_precision_advanced_simd(uint32_t raw);

/* Décode une instruction de type 'vcvtb'. */
GArchInstruction *armv7_read_arm_instr_a8_vcvtb_vcvtt(uint32_t raw);

/* Décode une instruction de type 'vdiv'. */
GArchInstruction *armv7_read_arm_instr_a8_vdiv(uint32_t raw);

/* Décode une instruction de type 'vdup'. */
GArchInstruction *armv7_read_arm_instr_a8_vdup_arm_core_register(uint32_t raw);

/* Décode une instruction de type 'veor'. */
GArchInstruction *armv7_read_arm_instr_a8_veor(uint32_t raw);

/* Décode une instruction de type 'vext'. */
GArchInstruction *armv7_read_arm_instr_a8_vext(uint32_t raw);

/* Décode une instruction de type 'vfma'. */
GArchInstruction *armv7_read_arm_instr_a8_vfma_vfms(uint32_t raw);

/* Décode une instruction de type 'vfnma'. */
GArchInstruction *armv7_read_arm_instr_a8_vfnma_vfnms(uint32_t raw);

/* Décode une instruction de type 'vhadd'. */
GArchInstruction *armv7_read_arm_instr_a8_vhadd_vhsub(uint32_t raw);

/* Décode une instruction de type 'vld1'. */
GArchInstruction *armv7_read_arm_instr_a8_vld1_multiple_single_elements(uint32_t raw);

/* Décode une instruction de type 'vld1'. */
GArchInstruction *armv7_read_arm_instr_a8_vld1_single_element_to_all_lanes(uint32_t raw);

/* Décode une instruction de type 'vld2'. */
GArchInstruction *armv7_read_arm_instr_a8_vld2_multiple_2_element_structures(uint32_t raw);

/* Décode une instruction de type 'vld2'. */
GArchInstruction *armv7_read_arm_instr_a8_vld2_single_2_element_structure_to_all_lanes(uint32_t raw);

/* Décode une instruction de type 'vld3'. */
GArchInstruction *armv7_read_arm_instr_a8_vld3_multiple_3_element_structures(uint32_t raw);

/* Décode une instruction de type 'vld3'. */
GArchInstruction *armv7_read_arm_instr_a8_vld3_single_3_element_structure_to_all_lanes(uint32_t raw);

/* Décode une instruction de type 'vld4'. */
GArchInstruction *armv7_read_arm_instr_a8_vld4_multiple_4_element_structures(uint32_t raw);

/* Décode une instruction de type 'vld4'. */
GArchInstruction *armv7_read_arm_instr_a8_vld4_single_4_element_structure_to_all_lanes(uint32_t raw);

/* Décode une instruction de type 'vldm'. */
GArchInstruction *armv7_read_arm_instr_a8_vldm(uint32_t raw);

/* Décode une instruction de type 'vmax'. */
GArchInstruction *armv7_read_arm_instr_a8_vmax_vmin_integer(uint32_t raw);

/* Décode une instruction de type 'vmax'. */
GArchInstruction *armv7_read_arm_instr_a8_vmax_vmin_floating_point(uint32_t raw);

/* Décode une instruction de type 'vmla'. */
GArchInstruction *armv7_read_arm_instr_a8_vmla_vmlal_vmls_vmlsl_integer(uint32_t raw);

/* Décode une instruction de type 'vmla'. */
GArchInstruction *armv7_read_arm_instr_a8_vmla_vmls_floating_point(uint32_t raw);

/* Décode une instruction de type 'vmov'. */
GArchInstruction *armv7_read_arm_instr_a8_vmov_between_arm_core_register_and_single_precision_register(uint32_t raw);

/* Décode une instruction de type 'vmov'. */
GArchInstruction *armv7_read_arm_instr_a8_vmov_between_two_arm_core_registers_and_two_single_precision_registers(uint32_t raw);

/* Décode une instruction de type 'vmov'. */
GArchInstruction *armv7_read_arm_instr_a8_vmov_between_two_arm_core_registers_and_a_doubleword_extension_register(uint32_t raw);

/* Décode une instruction de type 'vmovl'. */
GArchInstruction *armv7_read_arm_instr_a8_vmovl(uint32_t raw);

/* Décode une instruction de type 'vmovn'. */
GArchInstruction *armv7_read_arm_instr_a8_vmovn(uint32_t raw);

/* Décode une instruction de type 'vmrs'. */
GArchInstruction *armv7_read_arm_instr_a8_vmrs(uint32_t raw);

/* Décode une instruction de type 'vmsr'. */
GArchInstruction *armv7_read_arm_instr_a8_vmsr(uint32_t raw);

/* Décode une instruction de type 'vmul'. */
GArchInstruction *armv7_read_arm_instr_a8_vmul_vmull_integer_and_polynomial(uint32_t raw);

/* Décode une instruction de type 'vmul'. */
GArchInstruction *armv7_read_arm_instr_a8_vmul_floating_point(uint32_t raw);

/* Décode une instruction de type 'vmvn'. */
GArchInstruction *armv7_read_arm_instr_a8_vmvn_immediate(uint32_t raw);

/* Décode une instruction de type 'vmvn'. */
GArchInstruction *armv7_read_arm_instr_a8_vmvn_register(uint32_t raw);

/* Décode une instruction de type 'vneg'. */
GArchInstruction *armv7_read_arm_instr_a8_vneg(uint32_t raw);

/* Décode une instruction de type 'vnmla'. */
GArchInstruction *armv7_read_arm_instr_a8_vnmla_vnmls_vnmul(uint32_t raw);

/* Décode une instruction de type 'vorn'. */
GArchInstruction *armv7_read_arm_instr_a8_vorn_register(uint32_t raw);

/* Décode une instruction de type 'vorr'. */
GArchInstruction *armv7_read_arm_instr_a8_vorr_immediate(uint32_t raw);

/* Décode une instruction de type 'vorr'. */
GArchInstruction *armv7_read_arm_instr_a8_vorr_register(uint32_t raw);

/* Décode une instruction de type 'vpadal'. */
GArchInstruction *armv7_read_arm_instr_a8_vpadal(uint32_t raw);

/* Décode une instruction de type 'vpadd'. */
GArchInstruction *armv7_read_arm_instr_a8_vpadd_integer(uint32_t raw);

/* Décode une instruction de type 'vpadd'. */
GArchInstruction *armv7_read_arm_instr_a8_vpadd_floating_point(uint32_t raw);

/* Décode une instruction de type 'vpaddl'. */
GArchInstruction *armv7_read_arm_instr_a8_vpaddl(uint32_t raw);

/* Décode une instruction de type 'vpmax'. */
GArchInstruction *armv7_read_arm_instr_a8_vpmax_vpmin_integer(uint32_t raw);

/* Décode une instruction de type 'vpmax'. */
GArchInstruction *armv7_read_arm_instr_a8_vpmax_vpmin_floating_point(uint32_t raw);

/* Décode une instruction de type 'vpop'. */
GArchInstruction *armv7_read_arm_instr_a8_vpop(uint32_t raw);

/* Décode une instruction de type 'vpush'. */
GArchInstruction *armv7_read_arm_instr_a8_vpush(uint32_t raw);

/* Décode une instruction de type 'vqabs'. */
GArchInstruction *armv7_read_arm_instr_a8_vqabs(uint32_t raw);

/* Décode une instruction de type 'vqadd'. */
GArchInstruction *armv7_read_arm_instr_a8_vqadd(uint32_t raw);

/* Décode une instruction de type 'vqmovn'. */
GArchInstruction *armv7_read_arm_instr_a8_vqmovn_vqmovun(uint32_t raw);

/* Décode une instruction de type 'vqneg'. */
GArchInstruction *armv7_read_arm_instr_a8_vqneg(uint32_t raw);

/* Décode une instruction de type 'vqrshl'. */
GArchInstruction *armv7_read_arm_instr_a8_vqrshl(uint32_t raw);

/* Décode une instruction de type 'vqshl'. */
GArchInstruction *armv7_read_arm_instr_a8_vqshl_register(uint32_t raw);

/* Décode une instruction de type 'vqsub'. */
GArchInstruction *armv7_read_arm_instr_a8_vqsub(uint32_t raw);

/* Décode une instruction de type 'vraddhn'. */
GArchInstruction *armv7_read_arm_instr_a8_vraddhn(uint32_t raw);

/* Décode une instruction de type 'vrecpe'. */
GArchInstruction *armv7_read_arm_instr_a8_vrecpe(uint32_t raw);

/* Décode une instruction de type 'vrecps'. */
GArchInstruction *armv7_read_arm_instr_a8_vrecps(uint32_t raw);

/* Décode une instruction de type 'vrev16'. */
GArchInstruction *armv7_read_arm_instr_a8_vrev16_vrev32_vrev64(uint32_t raw);

/* Décode une instruction de type 'vrhadd'. */
GArchInstruction *armv7_read_arm_instr_a8_vrhadd(uint32_t raw);

/* Décode une instruction de type 'vrshl'. */
GArchInstruction *armv7_read_arm_instr_a8_vrshl(uint32_t raw);

/* Décode une instruction de type 'vrsqrte'. */
GArchInstruction *armv7_read_arm_instr_a8_vrsqrte(uint32_t raw);

/* Décode une instruction de type 'vrsqrts'. */
GArchInstruction *armv7_read_arm_instr_a8_vrsqrts(uint32_t raw);

/* Décode une instruction de type 'vrsubhn'. */
GArchInstruction *armv7_read_arm_instr_a8_vrsubhn(uint32_t raw);

/* Décode une instruction de type 'vshl'. */
GArchInstruction *armv7_read_arm_instr_a8_vshl_register(uint32_t raw);

/* Décode une instruction de type 'vsqrt'. */
GArchInstruction *armv7_read_arm_instr_a8_vsqrt(uint32_t raw);

/* Décode une instruction de type 'vst1'. */
GArchInstruction *armv7_read_arm_instr_a8_vst1_multiple_single_elements(uint32_t raw);

/* Décode une instruction de type 'vst2'. */
GArchInstruction *armv7_read_arm_instr_a8_vst2_multiple_2_element_structures(uint32_t raw);

/* Décode une instruction de type 'vst3'. */
GArchInstruction *armv7_read_arm_instr_a8_vst3_multiple_3_element_structures(uint32_t raw);

/* Décode une instruction de type 'vst4'. */
GArchInstruction *armv7_read_arm_instr_a8_vst4_multiple_4_element_structures(uint32_t raw);

/* Décode une instruction de type 'vstm'. */
GArchInstruction *armv7_read_arm_instr_a8_vstm(uint32_t raw);

/* Décode une instruction de type 'vstr'. */
GArchInstruction *armv7_read_arm_instr_a8_vstr(uint32_t raw);

/* Décode une instruction de type 'vsub'. */
GArchInstruction *armv7_read_arm_instr_a8_vsub_integer(uint32_t raw);

/* Décode une instruction de type 'vsub'. */
GArchInstruction *armv7_read_arm_instr_a8_vsub_floating_point(uint32_t raw);

/* Décode une instruction de type 'vsubhn'. */
GArchInstruction *armv7_read_arm_instr_a8_vsubhn(uint32_t raw);

/* Décode une instruction de type 'vsubl'. */
GArchInstruction *armv7_read_arm_instr_a8_vsubl_vsubw(uint32_t raw);

/* Décode une instruction de type 'vswp'. */
GArchInstruction *armv7_read_arm_instr_a8_vswp(uint32_t raw);

/* Décode une instruction de type 'vtbl'. */
GArchInstruction *armv7_read_arm_instr_a8_vtbl_vtbx(uint32_t raw);

/* Décode une instruction de type 'vtrn'. */
GArchInstruction *armv7_read_arm_instr_a8_vtrn(uint32_t raw);

/* Décode une instruction de type 'vtst'. */
GArchInstruction *armv7_read_arm_instr_a8_vtst(uint32_t raw);

/* Décode une instruction de type 'vuzp'. */
GArchInstruction *armv7_read_arm_instr_a8_vuzp(uint32_t raw);

/* Décode une instruction de type 'vzip'. */
GArchInstruction *armv7_read_arm_instr_a8_vzip(uint32_t raw);

/* Décode une instruction de type 'wfe'. */
GArchInstruction *armv7_read_arm_instr_a8_wfe(uint32_t raw);

/* Décode une instruction de type 'wfi'. */
GArchInstruction *armv7_read_arm_instr_a8_wfi(uint32_t raw);

/* Décode une instruction de type 'yield'. */
GArchInstruction *armv7_read_arm_instr_a8_yield(uint32_t raw);

/* Décode une instruction de type 'cps'. */
GArchInstruction *armv7_read_arm_instr_b9_cps_arm(uint32_t raw);

/* Décode une instruction de type 'eret'. */
GArchInstruction *armv7_read_arm_instr_b9_eret(uint32_t raw);

/* Décode une instruction de type 'hvc'. */
GArchInstruction *armv7_read_arm_instr_b9_hvc(uint32_t raw);

/* Décode une instruction de type 'ldm'. */
GArchInstruction *armv7_read_arm_instr_b9_ldm_exception_return(uint32_t raw);

/* Décode une instruction de type 'ldm'. */
GArchInstruction *armv7_read_arm_instr_b9_ldm_user_registers(uint32_t raw);

/* Décode une instruction de type 'mrs'. */
GArchInstruction *armv7_read_arm_instr_b9_mrs(uint32_t raw);

/* Décode une instruction de type 'mrs'. */
GArchInstruction *armv7_read_arm_instr_b9_mrs_banked_register(uint32_t raw);

/* Décode une instruction de type 'msr'. */
GArchInstruction *armv7_read_arm_instr_b9_msr_banked_register(uint32_t raw);

/* Décode une instruction de type 'msr'. */
GArchInstruction *armv7_read_arm_instr_b9_msr_immediate(uint32_t raw);

/* Décode une instruction de type 'msr'. */
GArchInstruction *armv7_read_arm_instr_b9_msr_register(uint32_t raw);

/* Décode une instruction de type 'rfe'. */
GArchInstruction *armv7_read_arm_instr_b9_rfe(uint32_t raw);

/* Décode une instruction de type 'smc'. */
GArchInstruction *armv7_read_arm_instr_b9_smc_previously_smi(uint32_t raw);

/* Décode une instruction de type 'srs'. */
GArchInstruction *armv7_read_arm_instr_b9_srs_arm(uint32_t raw);

/* Décode une instruction de type 'stm'. */
GArchInstruction *armv7_read_arm_instr_b9_stm_user_registers(uint32_t raw);

/* Décode une instruction de type 'subs'. */
GArchInstruction *armv7_read_arm_instr_b9_subs_pc_lr_and_related_instructions_arm(uint32_t raw);

/* Décode une instruction de type 'vmrs'. */
GArchInstruction *armv7_read_arm_instr_b9_vmrs(uint32_t raw);

/* Décode une instruction de type 'vmsr'. */
GArchInstruction *armv7_read_arm_instr_b9_vmsr(uint32_t raw);



#endif  /* _PLUGINS_ARM_V7_OPCODES_ARM_OPCODES_H */
