
/* Chrysalide - Outil d'analyse de fichiers binaires
 * hooks.h - définition des décrochages pour instructions ARMv7
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_ARM_V7_OPCODES_HOOKS_H
#define _PLUGINS_ARM_V7_OPCODES_HOOKS_H


#include "subidentifiers.h"


#include <arch/link.h> 
 
#include "../fetch.h" 
#include "../link.h" 
#include "../post.h" 
#include "../../link.h"



/* Définitions des décrochages pour l'établissement d'instructions */
static const instr_hook_fc _armv7_hooks[AOP7_ENC_COUNT][IPH_COUNT] = {

    [AOP7_A8_B_T1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_b_from_thumb,
        [IPH_LINK] = (instr_hook_fc)handle_arm_conditional_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_branch_instructions,
    },
    [AOP7_A8_B_T2] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_b_from_thumb,
        [IPH_LINK] = (instr_hook_fc)handle_arm_conditional_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_branch_instructions,
    },
    [AOP7_A8_B_T3] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_b_from_thumb,
        [IPH_LINK] = (instr_hook_fc)handle_arm_conditional_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_branch_instructions,
    },
    [AOP7_A8_B_T4] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_b_from_thumb,
        [IPH_LINK] = (instr_hook_fc)handle_arm_conditional_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_branch_instructions,
    },
    [AOP7_A8_B_A1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_b_from_arm,
        [IPH_LINK] = (instr_hook_fc)handle_arm_conditional_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_branch_instructions,
    },
    [AOP7_A8_BL_BLX_IMMEDIATE_T1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_bl_from_thumb,
        [IPH_LINK] = (instr_hook_fc)handle_call_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_branch_and_link_instructions,
    },
    [AOP7_A8_BL_BLX_IMMEDIATE_T2] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_blx_from_thumb,
        [IPH_LINK] = (instr_hook_fc)handle_call_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_branch_and_link_instructions,
    },
    [AOP7_A8_BL_BLX_IMMEDIATE_A1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_bl_from_arm,
        [IPH_LINK] = (instr_hook_fc)handle_call_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_branch_and_link_instructions,
    },
    [AOP7_A8_BL_BLX_IMMEDIATE_A2] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_blx_from_arm,
        [IPH_LINK] = (instr_hook_fc)handle_call_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_branch_and_link_instructions,
    },
    [AOP7_A8_BX_T1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_bx_from_thumb,
        [IPH_LINK] = (instr_hook_fc)handle_armv7_conditional_branch_from_register,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_BX_A1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_bx_from_arm,
        [IPH_LINK] = (instr_hook_fc)handle_armv7_conditional_branch_from_register,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_BXJ_T1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_bx_from_thumb,
        [IPH_LINK] = (instr_hook_fc)handle_armv7_conditional_branch_from_register,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_BXJ_A1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_bx_from_arm,
        [IPH_LINK] = (instr_hook_fc)handle_armv7_conditional_branch_from_register,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_CBNZ_CBZ_T1_0] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_cb_n_z,
        [IPH_LINK] = (instr_hook_fc)handle_comp_and_branch_if_true_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_comp_and_branch_instructions,
    },
    [AOP7_A8_CBNZ_CBZ_T1_1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_cb_n_z,
        [IPH_LINK] = (instr_hook_fc)handle_comp_and_branch_if_true_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_comp_and_branch_instructions,
    },
    [AOP7_A8_IT_T1] = {
        [IPH_FETCH] = (instr_hook_fc)build_it_instruction_suffix,
        [IPH_LINK] = (instr_hook_fc)NULL,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_LDM_LDMIA_LDMFD_THUMB_T1] = {
        [IPH_FETCH] = (instr_hook_fc)apply_write_back_from_registers,
        [IPH_LINK] = (instr_hook_fc)NULL,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_LDR_LITERAL_T1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_ldr_literal_from_thumb,
        [IPH_LINK] = (instr_hook_fc)NULL,
        [IPH_POST] = (instr_hook_fc)post_process_ldr_instructions,
    },
    [AOP7_A8_LDR_LITERAL_T2] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_ldr_literal_from_thumb,
        [IPH_LINK] = (instr_hook_fc)NULL,
        [IPH_POST] = (instr_hook_fc)post_process_ldr_instructions,
    },
    [AOP7_A8_LDR_LITERAL_A1] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_instruction_ldr_literal_from_arm,
        [IPH_LINK] = (instr_hook_fc)NULL,
        [IPH_POST] = (instr_hook_fc)post_process_ldr_instructions,
    },
    [AOP7_A8_POP_THUMB_T1] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_armv7_return_from_pop,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_POP_THUMB_T2] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_armv7_return_from_pop,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_POP_THUMB_T3] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_armv7_return_from_pop,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_POP_ARM_A1] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_armv7_return_from_pop,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_POP_ARM_A2] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_armv7_return_from_pop,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [AOP7_A8_STM_STMIA_STMEA_T1] = {
        [IPH_FETCH] = (instr_hook_fc)apply_write_back,
        [IPH_LINK] = (instr_hook_fc)NULL,
        [IPH_POST] = (instr_hook_fc)NULL,
    },

};



#endif  /* _PLUGINS_ARM_V7_OPCODES_HOOKS_H */
