
/* Chrysalide - Outil d'analyse de fichiers binaires
 * identifiers.h - définition des identifiants uniques pour ARMv7
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_ARM_V7_OPCODES_IDENTIFIERS_H
#define _PLUGINS_ARM_V7_OPCODES_IDENTIFIERS_H


/* Enumération de tous les opcodes */
typedef enum _ARMv7Opcodes
{
    AOP7_A8_ADC_IMMEDIATE,                  /* adc (immediate) (0x000)     */
    AOP7_A8_ADC_REGISTER,                   /* adc (register) (0x001)      */
    AOP7_A8_ADC_REGISTER_SHIFTED_REGISTER,  /* adc (register-shifted register) (0x002)*/
    AOP7_A8_ADD_IMMEDIATE_THUMB,            /* add (immediate, Thumb) (0x003)*/
    AOP7_A8_ADD_IMMEDIATE_ARM,              /* add (immediate, ARM) (0x004)*/
    AOP7_A8_ADD_REGISTER_THUMB,             /* add (register, Thumb) (0x005)*/
    AOP7_A8_ADD_REGISTER_ARM,               /* add (register, ARM) (0x006) */
    AOP7_A8_ADD_REGISTER_SHIFTED_REGISTER,  /* add (register-shifted register) (0x007)*/
    AOP7_A8_ADD_SP_PLUS_IMMEDIATE,          /* add (SP plus immediate) (0x008)*/
    AOP7_A8_ADD_SP_PLUS_REGISTER_THUMB,     /* add (SP plus register, Thumb) (0x009)*/
    AOP7_A8_ADD_SP_PLUS_REGISTER_ARM,       /* add (SP plus register, ARM) (0x00a)*/
    AOP7_A8_ADR,                            /* adr (0x00b)                 */
    AOP7_A8_AND_IMMEDIATE,                  /* and (immediate) (0x00c)     */
    AOP7_A8_AND_REGISTER,                   /* and (register) (0x00d)      */
    AOP7_A8_AND_REGISTER_SHIFTED_REGISTER,  /* and (register-shifted register) (0x00e)*/
    AOP7_A8_ASR_IMMEDIATE,                  /* asr (immediate) (0x00f)     */
    AOP7_A8_ASR_REGISTER,                   /* asr (register) (0x010)      */
    AOP7_A8_B,                              /* b (0x011)                   */
    AOP7_A8_BFC,                            /* bfc (0x012)                 */
    AOP7_A8_BFI,                            /* bfi (0x013)                 */
    AOP7_A8_BIC_IMMEDIATE,                  /* bic (immediate) (0x014)     */
    AOP7_A8_BIC_REGISTER,                   /* bic (register) (0x015)      */
    AOP7_A8_BIC_REGISTER_SHIFTED_REGISTER,  /* bic (register-shifted register) (0x016)*/
    AOP7_A8_BKPT,                           /* bkpt (0x017)                */
    AOP7_A8_BL_BLX_IMMEDIATE,               /* bl, BLX (immediate) (0x018) */
    AOP7_A8_BLX_REGISTER,                   /* blx (register) (0x019)      */
    AOP7_A8_BX,                             /* bx (0x01a)                  */
    AOP7_A8_BXJ,                            /* bxj (0x01b)                 */
    AOP7_A8_CBNZ_CBZ,                       /* cbnz, CBZ (0x01c)           */
    AOP7_A8_CDP_CDP2,                       /* cdp, CDP2 (0x01d)           */
    AOP7_A8_CLREX,                          /* clrex (0x01f)               */
    AOP7_A8_CLZ,                            /* clz (0x020)                 */
    AOP7_A8_CMN_IMMEDIATE,                  /* cmn (immediate) (0x021)     */
    AOP7_A8_CMN_REGISTER,                   /* cmn (register) (0x022)      */
    AOP7_A8_CMN_REGISTER_SHIFTED_REGISTER,  /* cmn (register-shifted register) (0x023)*/
    AOP7_A8_CMP_IMMEDIATE,                  /* cmp (immediate) (0x024)     */
    AOP7_A8_CMP_REGISTER,                   /* cmp (register) (0x025)      */
    AOP7_A8_CMP_REGISTER_SHIFTED_REGISTER,  /* cmp (register-shifted register) (0x026)*/
    AOP7_A8_DBG,                            /* dbg (0x029)                 */
    AOP7_A8_DMB,                            /* dmb (0x02a)                 */
    AOP7_A8_DSB,                            /* dsb (0x02b)                 */
    AOP7_A8_EOR_IMMEDIATE,                  /* eor (immediate) (0x02d)     */
    AOP7_A8_EOR_REGISTER,                   /* eor (register) (0x02e)      */
    AOP7_A8_EOR_REGISTER_SHIFTED_REGISTER,  /* eor (register-shifted register) (0x02f)*/
    AOP7_A8_ISB,                            /* isb (0x030)                 */
    AOP7_A8_IT,                             /* it (0x031)                  */
    AOP7_A8_LDC_LDC2_IMMEDIATE,             /* ldc, LDC2 (immediate) (0x032)*/
    AOP7_A8_LDC_LDC2_LITERAL,               /* ldc, LDC2 (literal) (0x033) */
    AOP7_A8_LDM_LDMIA_LDMFD_THUMB,          /* ldm/LDMIA/LDMFD (Thumb) (0x034)*/
    AOP7_A8_LDM_LDMIA_LDMFD_ARM,            /* ldm/LDMIA/LDMFD (ARM) (0x035)*/
    AOP7_A8_LDMDA_LDMFA,                    /* ldmda/LDMFA (0x036)         */
    AOP7_A8_LDMDB_LDMEA,                    /* ldmdb/LDMEA (0x037)         */
    AOP7_A8_LDMIB_LDMED,                    /* ldmib/LDMED (0x038)         */
    AOP7_A8_LDR_IMMEDIATE_THUMB,            /* ldr (immediate, Thumb) (0x039)*/
    AOP7_A8_LDR_IMMEDIATE_ARM,              /* ldr (immediate, ARM) (0x03a)*/
    AOP7_A8_LDR_LITERAL,                    /* ldr (literal) (0x03b)       */
    AOP7_A8_LDR_REGISTER_THUMB,             /* ldr (register, Thumb) (0x03c)*/
    AOP7_A8_LDR_REGISTER_ARM,               /* ldr (register, ARM) (0x03d) */
    AOP7_A8_LDRB_IMMEDIATE_THUMB,           /* ldrb (immediate, Thumb) (0x03e)*/
    AOP7_A8_LDRB_IMMEDIATE_ARM,             /* ldrb (immediate, ARM) (0x03f)*/
    AOP7_A8_LDRB_LITERAL,                   /* ldrb (literal) (0x040)      */
    AOP7_A8_LDRB_REGISTER,                  /* ldrb (register) (0x041)     */
    AOP7_A8_LDRBT,                          /* ldrbt (0x042)               */
    AOP7_A8_LDRD_IMMEDIATE,                 /* ldrd (immediate) (0x043)    */
    AOP7_A8_LDRD_LITERAL,                   /* ldrd (literal) (0x044)      */
    AOP7_A8_LDRD_REGISTER,                  /* ldrd (register) (0x045)     */
    AOP7_A8_LDREX,                          /* ldrex (0x046)               */
    AOP7_A8_LDREXB,                         /* ldrexb (0x047)              */
    AOP7_A8_LDREXD,                         /* ldrexd (0x048)              */
    AOP7_A8_LDREXH,                         /* ldrexh (0x049)              */
    AOP7_A8_LDRH_IMMEDIATE_THUMB,           /* ldrh (immediate, Thumb) (0x04a)*/
    AOP7_A8_LDRH_IMMEDIATE_ARM,             /* ldrh (immediate, ARM) (0x04b)*/
    AOP7_A8_LDRH_LITERAL,                   /* ldrh (literal) (0x04c)      */
    AOP7_A8_LDRH_REGISTER,                  /* ldrh (register) (0x04d)     */
    AOP7_A8_LDRHT,                          /* ldrht (0x04e)               */
    AOP7_A8_LDRSB_IMMEDIATE,                /* ldrsb (immediate) (0x04f)   */
    AOP7_A8_LDRSB_LITERAL,                  /* ldrsb (literal) (0x050)     */
    AOP7_A8_LDRSB_REGISTER,                 /* ldrsb (register) (0x051)    */
    AOP7_A8_LDRSBT,                         /* ldrsbt (0x052)              */
    AOP7_A8_LDRSH_IMMEDIATE,                /* ldrsh (immediate) (0x053)   */
    AOP7_A8_LDRSH_LITERAL,                  /* ldrsh (literal) (0x054)     */
    AOP7_A8_LDRSH_REGISTER,                 /* ldrsh (register) (0x055)    */
    AOP7_A8_LDRSHT,                         /* ldrsht (0x056)              */
    AOP7_A8_LDRT,                           /* ldrt (0x057)                */
    AOP7_A8_LSL_IMMEDIATE,                  /* lsl (immediate) (0x059)     */
    AOP7_A8_LSL_REGISTER,                   /* lsl (register) (0x05a)      */
    AOP7_A8_LSR_IMMEDIATE,                  /* lsr (immediate) (0x05b)     */
    AOP7_A8_LSR_REGISTER,                   /* lsr (register) (0x05c)      */
    AOP7_A8_MCR_MCR2,                       /* mcr, MCR2 (0x05d)           */
    AOP7_A8_MCRR_MCRR2,                     /* mcrr, MCRR2 (0x05e)         */
    AOP7_A8_MLA,                            /* mla (0x05f)                 */
    AOP7_A8_MLS,                            /* mls (0x060)                 */
    AOP7_A8_MOV_IMMEDIATE,                  /* mov (immediate) (0x061)     */
    AOP7_A8_MOV_REGISTER_THUMB,             /* mov (register, Thumb) (0x062)*/
    AOP7_A8_MOV_REGISTER_ARM,               /* mov (register, ARM) (0x063) */
    AOP7_A8_MOVT,                           /* movt (0x065)                */
    AOP7_A8_MRC_MRC2,                       /* mrc, MRC2 (0x066)           */
    AOP7_A8_MRRC_MRRC2,                     /* mrrc, MRRC2 (0x067)         */
    AOP7_A8_MRS,                            /* mrs (0x068)                 */
    AOP7_A8_MSR_IMMEDIATE,                  /* msr (immediate) (0x06a)     */
    AOP7_A8_MSR_REGISTER,                   /* msr (register) (0x06b)      */
    AOP7_A8_MUL,                            /* mul (0x06d)                 */
    AOP7_A8_MVN_IMMEDIATE,                  /* mvn (immediate) (0x06e)     */
    AOP7_A8_MVN_REGISTER,                   /* mvn (register) (0x06f)      */
    AOP7_A8_MVN_REGISTER_SHIFTED_REGISTER,  /* mvn (register-shifted register) (0x070)*/
    AOP7_A8_NOP,                            /* nop (0x072)                 */
    AOP7_A8_ORN_IMMEDIATE,                  /* orn (immediate) (0x073)     */
    AOP7_A8_ORN_REGISTER,                   /* orn (register) (0x074)      */
    AOP7_A8_ORR_IMMEDIATE,                  /* orr (immediate) (0x075)     */
    AOP7_A8_ORR_REGISTER,                   /* orr (register) (0x076)      */
    AOP7_A8_ORR_REGISTER_SHIFTED_REGISTER,  /* orr (register-shifted register) (0x077)*/
    AOP7_A8_PKH,                            /* pkh (0x078)                 */
    AOP7_A8_PLD_PLDW_IMMEDIATE,             /* pld, PLDW (immediate) (0x079)*/
    AOP7_A8_PLD_LITERAL,                    /* pld (literal) (0x07a)       */
    AOP7_A8_PLD_PLDW_REGISTER,              /* pld, PLDW (register) (0x07b)*/
    AOP7_A8_PLI_IMMEDIATE_LITERAL,          /* pli (immediate, literal) (0x07c)*/
    AOP7_A8_PLI_REGISTER,                   /* pli (register) (0x07d)      */
    AOP7_A8_POP_THUMB,                      /* pop (Thumb) (0x07e)         */
    AOP7_A8_POP_ARM,                        /* pop (ARM) (0x07f)           */
    AOP7_A8_PUSH,                           /* push (0x080)                */
    AOP7_A8_QADD,                           /* qadd (0x081)                */
    AOP7_A8_QADD16,                         /* qadd16 (0x082)              */
    AOP7_A8_QADD8,                          /* qadd8 (0x083)               */
    AOP7_A8_QASX,                           /* qasx (0x084)                */
    AOP7_A8_QDADD,                          /* qdadd (0x085)               */
    AOP7_A8_QDSUB,                          /* qdsub (0x086)               */
    AOP7_A8_QSAX,                           /* qsax (0x087)                */
    AOP7_A8_QSUB,                           /* qsub (0x088)                */
    AOP7_A8_QSUB16,                         /* qsub16 (0x089)              */
    AOP7_A8_QSUB8,                          /* qsub8 (0x08a)               */
    AOP7_A8_RBIT,                           /* rbit (0x08b)                */
    AOP7_A8_REV,                            /* rev (0x08c)                 */
    AOP7_A8_REV16,                          /* rev16 (0x08d)               */
    AOP7_A8_REVSH,                          /* revsh (0x08e)               */
    AOP7_A8_ROR_IMMEDIATE,                  /* ror (immediate) (0x090)     */
    AOP7_A8_ROR_REGISTER,                   /* ror (register) (0x091)      */
    AOP7_A8_RRX,                            /* rrx (0x092)                 */
    AOP7_A8_RSB_IMMEDIATE,                  /* rsb (immediate) (0x093)     */
    AOP7_A8_RSB_REGISTER,                   /* rsb (register) (0x094)      */
    AOP7_A8_RSB_REGISTER_SHIFTED_REGISTER,  /* rsb (register-shifted register) (0x095)*/
    AOP7_A8_RSC_IMMEDIATE,                  /* rsc (immediate) (0x096)     */
    AOP7_A8_RSC_REGISTER,                   /* rsc (register) (0x097)      */
    AOP7_A8_RSC_REGISTER_SHIFTED_REGISTER,  /* rsc (register-shifted register) (0x098)*/
    AOP7_A8_SADD16,                         /* sadd16 (0x099)              */
    AOP7_A8_SADD8,                          /* sadd8 (0x09a)               */
    AOP7_A8_SASX,                           /* sasx (0x09b)                */
    AOP7_A8_SBC_IMMEDIATE,                  /* sbc (immediate) (0x09c)     */
    AOP7_A8_SBC_REGISTER,                   /* sbc (register) (0x09d)      */
    AOP7_A8_SBC_REGISTER_SHIFTED_REGISTER,  /* sbc (register-shifted register) (0x09e)*/
    AOP7_A8_SBFX,                           /* sbfx (0x09f)                */
    AOP7_A8_SDIV,                           /* sdiv (0x0a0)                */
    AOP7_A8_SEL,                            /* sel (0x0a1)                 */
    AOP7_A8_SETEND,                         /* setend (0x0a2)              */
    AOP7_A8_SEV,                            /* sev (0x0a3)                 */
    AOP7_A8_SHADD16,                        /* shadd16 (0x0a4)             */
    AOP7_A8_SHADD8,                         /* shadd8 (0x0a5)              */
    AOP7_A8_SHASX,                          /* shasx (0x0a6)               */
    AOP7_A8_SHSAX,                          /* shsax (0x0a7)               */
    AOP7_A8_SHSUB16,                        /* shsub16 (0x0a8)             */
    AOP7_A8_SHSUB8,                         /* shsub8 (0x0a9)              */
    AOP7_A8_SMLABB_SMLABT_SMLATB_SMLATT,    /* smlabb, SMLABT, SMLATB, SMLATT (0x0ab)*/
    AOP7_A8_SMLAD,                          /* smlad (0x0ac)               */
    AOP7_A8_SMLAL,                          /* smlal (0x0ad)               */
    AOP7_A8_SMLALBB_SMLALBT_SMLALTB_SMLALTT,/* smlalbb, SMLALBT, SMLALTB, SMLALTT (0x0ae)*/
    AOP7_A8_SMLALD,                         /* smlald (0x0af)              */
    AOP7_A8_SMLAWB_SMLAWT,                  /* smlawb, SMLAWT (0x0b0)      */
    AOP7_A8_SMLSD,                          /* smlsd (0x0b1)               */
    AOP7_A8_SMLSLD,                         /* smlsld (0x0b2)              */
    AOP7_A8_SMMLA,                          /* smmla (0x0b3)               */
    AOP7_A8_SMMLS,                          /* smmls (0x0b4)               */
    AOP7_A8_SMMUL,                          /* smmul (0x0b5)               */
    AOP7_A8_SMUAD,                          /* smuad (0x0b6)               */
    AOP7_A8_SMULBB_SMULBT_SMULTB_SMULTT,    /* smulbb, SMULBT, SMULTB, SMULTT (0x0b7)*/
    AOP7_A8_SMULL,                          /* smull (0x0b8)               */
    AOP7_A8_SMULWB_SMULWT,                  /* smulwb, SMULWT (0x0b9)      */
    AOP7_A8_SMUSD,                          /* smusd (0x0ba)               */
    AOP7_A8_SSAT,                           /* ssat (0x0bc)                */
    AOP7_A8_SSAT16,                         /* ssat16 (0x0bd)              */
    AOP7_A8_SSAX,                           /* ssax (0x0be)                */
    AOP7_A8_SSUB16,                         /* ssub16 (0x0bf)              */
    AOP7_A8_SSUB8,                          /* ssub8 (0x0c0)               */
    AOP7_A8_STC_STC2,                       /* stc, STC2 (0x0c1)           */
    AOP7_A8_STM_STMIA_STMEA,                /* stm (STMIA, STMEA) (0x0c2)  */
    AOP7_A8_STMDA_STMED,                    /* stmda (STMED) (0x0c3)       */
    AOP7_A8_STMDB_STMFD,                    /* stmdb (STMFD) (0x0c4)       */
    AOP7_A8_STMIB_STMFA,                    /* stmib (STMFA) (0x0c5)       */
    AOP7_A8_STR_IMMEDIATE_THUMB,            /* str (immediate, Thumb) (0x0c6)*/
    AOP7_A8_STR_IMMEDIATE_ARM,              /* str (immediate, ARM) (0x0c7)*/
    AOP7_A8_STR_REGISTER,                   /* str (register) (0x0c8)      */
    AOP7_A8_STRB_IMMEDIATE_THUMB,           /* strb (immediate, Thumb) (0x0c9)*/
    AOP7_A8_STRB_IMMEDIATE_ARM,             /* strb (immediate, ARM) (0x0ca)*/
    AOP7_A8_STRB_REGISTER,                  /* strb (register) (0x0cb)     */
    AOP7_A8_STRBT,                          /* strbt (0x0cc)               */
    AOP7_A8_STRD_IMMEDIATE,                 /* strd (immediate) (0x0cd)    */
    AOP7_A8_STRD_REGISTER,                  /* strd (register) (0x0ce)     */
    AOP7_A8_STREX,                          /* strex (0x0cf)               */
    AOP7_A8_STREXB,                         /* strexb (0x0d0)              */
    AOP7_A8_STREXD,                         /* strexd (0x0d1)              */
    AOP7_A8_STREXH,                         /* strexh (0x0d2)              */
    AOP7_A8_STRH_IMMEDIATE_THUMB,           /* strh (immediate, Thumb) (0x0d3)*/
    AOP7_A8_STRH_IMMEDIATE_ARM,             /* strh (immediate, ARM) (0x0d4)*/
    AOP7_A8_STRH_REGISTER,                  /* strh (register) (0x0d5)     */
    AOP7_A8_STRHT,                          /* strht (0x0d6)               */
    AOP7_A8_STRT,                           /* strt (0x0d7)                */
    AOP7_A8_SUB_IMMEDIATE_THUMB,            /* sub (immediate, Thumb) (0x0d8)*/
    AOP7_A8_SUB_IMMEDIATE_ARM,              /* sub (immediate, ARM) (0x0d9)*/
    AOP7_A8_SUB_REGISTER,                   /* sub (register) (0x0da)      */
    AOP7_A8_SUB_REGISTER_SHIFTED_REGISTER,  /* sub (register-shifted register) (0x0db)*/
    AOP7_A8_SUB_SP_MINUS_IMMEDIATE,         /* sub (SP minus immediate) (0x0dc)*/
    AOP7_A8_SUB_SP_MINUS_REGISTER,          /* sub (SP minus register) (0x0dd)*/
    AOP7_A8_SVC_PREVIOUSLY_SWI,             /* svc (previously SWI) (0x0df)*/
    AOP7_A8_SWP_SWPB,                       /* swp, SWPB (0x0e0)           */
    AOP7_A8_SXTAB,                          /* sxtab (0x0e1)               */
    AOP7_A8_SXTAB16,                        /* sxtab16 (0x0e2)             */
    AOP7_A8_SXTAH,                          /* sxtah (0x0e3)               */
    AOP7_A8_SXTB,                           /* sxtb (0x0e4)                */
    AOP7_A8_SXTB16,                         /* sxtb16 (0x0e5)              */
    AOP7_A8_SXTH,                           /* sxth (0x0e6)                */
    AOP7_A8_TBB_TBH,                        /* tbb, TBH (0x0e7)            */
    AOP7_A8_TEQ_IMMEDIATE,                  /* teq (immediate) (0x0e8)     */
    AOP7_A8_TEQ_REGISTER,                   /* teq (register) (0x0e9)      */
    AOP7_A8_TEQ_REGISTER_SHIFTED_REGISTER,  /* teq (register-shifted register) (0x0ea)*/
    AOP7_A8_TST_IMMEDIATE,                  /* tst (immediate) (0x0eb)     */
    AOP7_A8_TST_REGISTER,                   /* tst (register) (0x0ec)      */
    AOP7_A8_TST_REGISTER_SHIFTED_REGISTER,  /* tst (register-shifted register) (0x0ed)*/
    AOP7_A8_UADD16,                         /* uadd16 (0x0ee)              */
    AOP7_A8_UADD8,                          /* uadd8 (0x0ef)               */
    AOP7_A8_UASX,                           /* uasx (0x0f0)                */
    AOP7_A8_UBFX,                           /* ubfx (0x0f1)                */
    AOP7_A8_UDF,                            /* udf (0x0f2)                 */
    AOP7_A8_UDIV,                           /* udiv (0x0f3)                */
    AOP7_A8_UHADD16,                        /* uhadd16 (0x0f4)             */
    AOP7_A8_UHADD8,                         /* uhadd8 (0x0f5)              */
    AOP7_A8_UHASX,                          /* uhasx (0x0f6)               */
    AOP7_A8_UHSAX,                          /* uhsax (0x0f7)               */
    AOP7_A8_UHSUB16,                        /* uhsub16 (0x0f8)             */
    AOP7_A8_UHSUB8,                         /* uhsub8 (0x0f9)              */
    AOP7_A8_UMAAL,                          /* umaal (0x0fa)               */
    AOP7_A8_UMLAL,                          /* umlal (0x0fb)               */
    AOP7_A8_UMULL,                          /* umull (0x0fc)               */
    AOP7_A8_UQADD16,                        /* uqadd16 (0x0fd)             */
    AOP7_A8_UQADD8,                         /* uqadd8 (0x0fe)              */
    AOP7_A8_UQASX,                          /* uqasx (0x0ff)               */
    AOP7_A8_UQSAX,                          /* uqsax (0x100)               */
    AOP7_A8_UQSUB16,                        /* uqsub16 (0x101)             */
    AOP7_A8_UQSUB8,                         /* uqsub8 (0x102)              */
    AOP7_A8_USAD8,                          /* usad8 (0x103)               */
    AOP7_A8_USADA8,                         /* usada8 (0x104)              */
    AOP7_A8_USAT,                           /* usat (0x105)                */
    AOP7_A8_USAT16,                         /* usat16 (0x106)              */
    AOP7_A8_USAX,                           /* usax (0x107)                */
    AOP7_A8_USUB16,                         /* usub16 (0x108)              */
    AOP7_A8_USUB8,                          /* usub8 (0x109)               */
    AOP7_A8_UXTAB,                          /* uxtab (0x10a)               */
    AOP7_A8_UXTAB16,                        /* uxtab16 (0x10b)             */
    AOP7_A8_UXTAH,                          /* uxtah (0x10c)               */
    AOP7_A8_UXTB,                           /* uxtb (0x10d)                */
    AOP7_A8_UXTB16,                         /* uxtb16 (0x10e)              */
    AOP7_A8_UXTH,                           /* uxth (0x10f)                */
    AOP7_A8_VABA_VABAL,                     /* vaba, VABAL (0x110)         */
    AOP7_A8_VABD_VABDL_INTEGER,             /* vabd, VABDL (integer) (0x111)*/
    AOP7_A8_VABD_FLOATING_POINT,            /* vabd (floating-point) (0x112)*/
    AOP7_A8_VABS,                           /* vabs (0x113)                */
    AOP7_A8_VACGE_VACGT_VACLE_VACLT,        /* vacge, VACGT, VACLE, VACLT (0x114)*/
    AOP7_A8_VADD_INTEGER,                   /* vadd (integer) (0x115)      */
    AOP7_A8_VADD_FLOATING_POINT,            /* vadd (floating-point) (0x116)*/
    AOP7_A8_VADDHN,                         /* vaddhn (0x117)              */
    AOP7_A8_VADDL_VADDW,                    /* vaddl, VADDW (0x118)        */
    AOP7_A8_VAND_REGISTER,                  /* vand (register) (0x11a)     */
    AOP7_A8_VBIC_IMMEDIATE,                 /* vbic (immediate) (0x11b)    */
    AOP7_A8_VBIC_REGISTER,                  /* vbic (register) (0x11c)     */
    AOP7_A8_VBIF_VBIT_VBSL,                 /* vbif, VBIT, VBSL (0x11d)    */
    AOP7_A8_VCEQ_REGISTER,                  /* vceq (register) (0x11e)     */
    AOP7_A8_VCEQ_IMMEDIATE_0,               /* vceq (immediate #0) (0x11f) */
    AOP7_A8_VCGE_REGISTER,                  /* vcge (register) (0x120)     */
    AOP7_A8_VCGE_IMMEDIATE_0,               /* vcge (immediate #0) (0x121) */
    AOP7_A8_VCGT_REGISTER,                  /* vcgt (register) (0x122)     */
    AOP7_A8_VCGT_IMMEDIATE_0,               /* vcgt (immediate #0) (0x123) */
    AOP7_A8_VCLE_IMMEDIATE_0,               /* vcle (immediate #0) (0x125) */
    AOP7_A8_VCLS,                           /* vcls (0x126)                */
    AOP7_A8_VCLT_IMMEDIATE_0,               /* vclt (immediate #0) (0x128) */
    AOP7_A8_VCLZ,                           /* vclz (0x129)                */
    AOP7_A8_VCMP_VCMPE,                     /* vcmp, VCMPE (0x12a)         */
    AOP7_A8_VCNT,                           /* vcnt (0x12b)                */
    AOP7_A8_VCVT_BETWEEN_FLOATING_POINT_AND_INTEGER_ADVANCED_SIMD,/* vcvt (between floating-point and integer, Advanced SIMD) (0x12c)*/
    AOP7_A8_VCVT_VCVTR_BETWEEN_FLOATING_POINT_AND_INTEGER_FLOATING_POINT,/* vcvt, VCVTR (between floating-point and integer, Floating-point) (0x12d)*/
    AOP7_A8_VCVT_BETWEEN_DOUBLE_PRECISION_AND_SINGLE_PRECISION,/* vcvt (between double-precision and single-precision) (0x12e)*/
    AOP7_A8_VCVT_BETWEEN_HALF_PRECISION_AND_SINGLE_PRECISION_ADVANCED_SIMD,/* vcvt (between half-precision and single-precision, Advanced SIMD) (0x12f)*/
    AOP7_A8_VCVTB_VCVTT,                    /* vcvtb, VCVTT (0x130)        */
    AOP7_A8_VDIV,                           /* vdiv (0x131)                */
    AOP7_A8_VDUP_ARM_CORE_REGISTER,         /* vdup (ARM core register) (0x132)*/
    AOP7_A8_VEOR,                           /* veor (0x133)                */
    AOP7_A8_VEXT,                           /* vext (0x134)                */
    AOP7_A8_VFMA_VFMS,                      /* vfma, VFMS (0x135)          */
    AOP7_A8_VFNMA_VFNMS,                    /* vfnma, VFNMS (0x136)        */
    AOP7_A8_VHADD_VHSUB,                    /* vhadd, VHSUB (0x137)        */
    AOP7_A8_VLD1_MULTIPLE_SINGLE_ELEMENTS,  /* vld1 (multiple single elements) (0x138)*/
    AOP7_A8_VLD1_SINGLE_ELEMENT_TO_ALL_LANES,/* vld1 (single element to all lanes) (0x139)*/
    AOP7_A8_VLD2_MULTIPLE_2_ELEMENT_STRUCTURES,/* vld2 (multiple 2-element structures) (0x13a)*/
    AOP7_A8_VLD2_SINGLE_2_ELEMENT_STRUCTURE_TO_ALL_LANES,/* vld2 (single 2-element structure to all lanes) (0x13b)*/
    AOP7_A8_VLD3_MULTIPLE_3_ELEMENT_STRUCTURES,/* vld3 (multiple 3-element structures) (0x13c)*/
    AOP7_A8_VLD3_SINGLE_3_ELEMENT_STRUCTURE_TO_ALL_LANES,/* vld3 (single 3-element structure to all lanes) (0x13d)*/
    AOP7_A8_VLD4_MULTIPLE_4_ELEMENT_STRUCTURES,/* vld4 (multiple 4-element structures) (0x13e)*/
    AOP7_A8_VLD4_SINGLE_4_ELEMENT_STRUCTURE_TO_ALL_LANES,/* vld4 (single 4-element structure to all lanes) (0x13f)*/
    AOP7_A8_VLDM,                           /* vldm (0x140)                */
    AOP7_A8_VMAX_VMIN_INTEGER,              /* vmax, VMIN (integer) (0x141)*/
    AOP7_A8_VMAX_VMIN_FLOATING_POINT,       /* vmax, VMIN (floating-point) (0x142)*/
    AOP7_A8_VMLA_VMLAL_VMLS_VMLSL_INTEGER,  /* vmla, VMLAL, VMLS, VMLSL (integer) (0x143)*/
    AOP7_A8_VMLA_VMLS_FLOATING_POINT,       /* vmla, VMLS (floating-point) (0x144)*/
    AOP7_A8_VMOV_BETWEEN_ARM_CORE_REGISTER_AND_SINGLE_PRECISION_REGISTER,/* vmov (between ARM core register and single-precision register) (0x145)*/
    AOP7_A8_VMOV_BETWEEN_TWO_ARM_CORE_REGISTERS_AND_TWO_SINGLE_PRECISION_REGISTERS,/* vmov (between two ARM core registers and two single-precision registers) (0x146)*/
    AOP7_A8_VMOV_BETWEEN_TWO_ARM_CORE_REGISTERS_AND_A_DOUBLEWORD_EXTENSION_REGISTER,/* vmov (between two ARM core registers and a doubleword extension register) (0x147)*/
    AOP7_A8_VMOVL,                          /* vmovl (0x148)               */
    AOP7_A8_VMOVN,                          /* vmovn (0x149)               */
    AOP7_A8_VMRS,                           /* vmrs (0x14a)                */
    AOP7_A8_VMSR,                           /* vmsr (0x14b)                */
    AOP7_A8_VMUL_VMULL_INTEGER_AND_POLYNOMIAL,/* vmul, VMULL (integer and polynomial) (0x14c)*/
    AOP7_A8_VMUL_FLOATING_POINT,            /* vmul (floating-point) (0x14d)*/
    AOP7_A8_VMVN_IMMEDIATE,                 /* vmvn (immediate) (0x14e)    */
    AOP7_A8_VMVN_REGISTER,                  /* vmvn (register) (0x14f)     */
    AOP7_A8_VNEG,                           /* vneg (0x150)                */
    AOP7_A8_VNMLA_VNMLS_VNMUL,              /* vnmla, VNMLS, VNMUL (0x151) */
    AOP7_A8_VORN_REGISTER,                  /* vorn (register) (0x153)     */
    AOP7_A8_VORR_IMMEDIATE,                 /* vorr (immediate) (0x154)    */
    AOP7_A8_VORR_REGISTER,                  /* vorr (register) (0x155)     */
    AOP7_A8_VPADAL,                         /* vpadal (0x156)              */
    AOP7_A8_VPADD_INTEGER,                  /* vpadd (integer) (0x157)     */
    AOP7_A8_VPADD_FLOATING_POINT,           /* vpadd (floating-point) (0x158)*/
    AOP7_A8_VPADDL,                         /* vpaddl (0x159)              */
    AOP7_A8_VPMAX_VPMIN_INTEGER,            /* vpmax, VPMIN (integer) (0x15a)*/
    AOP7_A8_VPMAX_VPMIN_FLOATING_POINT,     /* vpmax, VPMIN (floating-point) (0x15b)*/
    AOP7_A8_VPOP,                           /* vpop (0x15c)                */
    AOP7_A8_VPUSH,                          /* vpush (0x15d)               */
    AOP7_A8_VQABS,                          /* vqabs (0x15e)               */
    AOP7_A8_VQADD,                          /* vqadd (0x15f)               */
    AOP7_A8_VQMOVN_VQMOVUN,                 /* vqmovn, VQMOVUN (0x160)     */
    AOP7_A8_VQNEG,                          /* vqneg (0x161)               */
    AOP7_A8_VQRSHL,                         /* vqrshl (0x162)              */
    AOP7_A8_VQSHL_REGISTER,                 /* vqshl (register) (0x163)    */
    AOP7_A8_VQSUB,                          /* vqsub (0x164)               */
    AOP7_A8_VRADDHN,                        /* vraddhn (0x165)             */
    AOP7_A8_VRECPE,                         /* vrecpe (0x166)              */
    AOP7_A8_VRECPS,                         /* vrecps (0x167)              */
    AOP7_A8_VREV16_VREV32_VREV64,           /* vrev16, VREV32, VREV64 (0x168)*/
    AOP7_A8_VRHADD,                         /* vrhadd (0x169)              */
    AOP7_A8_VRSHL,                          /* vrshl (0x16a)               */
    AOP7_A8_VRSQRTE,                        /* vrsqrte (0x16b)             */
    AOP7_A8_VRSQRTS,                        /* vrsqrts (0x16c)             */
    AOP7_A8_VRSUBHN,                        /* vrsubhn (0x16d)             */
    AOP7_A8_VSHL_REGISTER,                  /* vshl (register) (0x16e)     */
    AOP7_A8_VSQRT,                          /* vsqrt (0x16f)               */
    AOP7_A8_VST1_MULTIPLE_SINGLE_ELEMENTS,  /* vst1 (multiple single elements) (0x170)*/
    AOP7_A8_VST2_MULTIPLE_2_ELEMENT_STRUCTURES,/* vst2 (multiple 2-element structures) (0x171)*/
    AOP7_A8_VST3_MULTIPLE_3_ELEMENT_STRUCTURES,/* vst3 (multiple 3-element structures) (0x172)*/
    AOP7_A8_VST4_MULTIPLE_4_ELEMENT_STRUCTURES,/* vst4 (multiple 4-element structures) (0x173)*/
    AOP7_A8_VSTM,                           /* vstm (0x174)                */
    AOP7_A8_VSTR,                           /* vstr (0x175)                */
    AOP7_A8_VSUB_INTEGER,                   /* vsub (integer) (0x176)      */
    AOP7_A8_VSUB_FLOATING_POINT,            /* vsub (floating-point) (0x177)*/
    AOP7_A8_VSUBHN,                         /* vsubhn (0x178)              */
    AOP7_A8_VSUBL_VSUBW,                    /* vsubl, VSUBW (0x179)        */
    AOP7_A8_VSWP,                           /* vswp (0x17a)                */
    AOP7_A8_VTBL_VTBX,                      /* vtbl, VTBX (0x17b)          */
    AOP7_A8_VTRN,                           /* vtrn (0x17c)                */
    AOP7_A8_VTST,                           /* vtst (0x17d)                */
    AOP7_A8_VUZP,                           /* vuzp (0x17e)                */
    AOP7_A8_VZIP,                           /* vzip (0x17f)                */
    AOP7_A8_WFE,                            /* wfe (0x180)                 */
    AOP7_A8_WFI,                            /* wfi (0x181)                 */
    AOP7_A8_YIELD,                          /* yield (0x182)               */
    AOP7_A9_ENTERX_LEAVEX,                  /* enterx, LEAVEX (0x183)      */
    AOP7_B9_CPS_THUMB,                      /* cps (Thumb) (0x184)         */
    AOP7_B9_CPS_ARM,                        /* cps (ARM) (0x185)           */
    AOP7_B9_ERET,                           /* eret (0x186)                */
    AOP7_B9_HVC,                            /* hvc (0x187)                 */
    AOP7_B9_LDM_EXCEPTION_RETURN,           /* ldm (exception return) (0x188)*/
    AOP7_B9_LDM_USER_REGISTERS,             /* ldm (User registers) (0x189)*/
    AOP7_B9_MRS,                            /* mrs (0x18b)                 */
    AOP7_B9_MRS_BANKED_REGISTER,            /* mrs (Banked register) (0x18c)*/
    AOP7_B9_MSR_BANKED_REGISTER,            /* msr (Banked register) (0x18d)*/
    AOP7_B9_MSR_IMMEDIATE,                  /* msr (immediate) (0x18e)     */
    AOP7_B9_MSR_REGISTER,                   /* msr (register) (0x18f)      */
    AOP7_B9_RFE,                            /* rfe (0x190)                 */
    AOP7_B9_SMC_PREVIOUSLY_SMI,             /* smc (previously SMI) (0x191)*/
    AOP7_B9_SRS_THUMB,                      /* srs (Thumb) (0x192)         */
    AOP7_B9_SRS_ARM,                        /* srs (ARM) (0x193)           */
    AOP7_B9_STM_USER_REGISTERS,             /* stm (User registers) (0x194)*/
    AOP7_B9_SUBS_PC_LR_THUMB,               /* subs PC, LR (Thumb) (0x196) */
    AOP7_B9_SUBS_PC_LR_AND_RELATED_INSTRUCTIONS_ARM,/* subs PC, LR and related instructions (ARM) (0x197)*/
    AOP7_B9_VMRS,                           /* vmrs (0x198)                */
    AOP7_B9_VMSR,                           /* vmsr (0x199)                */

    AOP7_COUNT

} ARMv7Opcodes;



#endif  /* _PLUGINS_ARM_V7_OPCODES_IDENTIFIERS_H */
