
/* Chrysalide - Outil d'analyse de fichiers binaires
 * thumb_16_opcodes.h - prototypes pour la traduction d'instructions ARMv7
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_ARM_V7_OPCODES_THUMB_16_OPCODES_H
#define _PLUGINS_ARM_V7_OPCODES_THUMB_16_OPCODES_H


#include <stdint.h> 
 
#include <arch/instruction.h>



/* Décode une instruction de type 'adc'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_adc_register(uint16_t raw);

/* Décode une instruction de type 'add'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_add_immediate_thumb(uint16_t raw);

/* Décode une instruction de type 'add'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_add_register_thumb(uint16_t raw);

/* Décode une instruction de type 'add'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_add_sp_plus_immediate(uint16_t raw);

/* Décode une instruction de type 'add'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_add_sp_plus_register_thumb(uint16_t raw);

/* Décode une instruction de type 'adr'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_adr(uint16_t raw);

/* Décode une instruction de type 'and'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_and_register(uint16_t raw);

/* Décode une instruction de type 'asr'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_asr_immediate(uint16_t raw);

/* Décode une instruction de type 'asr'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_asr_register(uint16_t raw);

/* Décode une instruction de type 'b'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_b(uint16_t raw);

/* Décode une instruction de type 'bic'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_bic_register(uint16_t raw);

/* Décode une instruction de type 'bkpt'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_bkpt(uint16_t raw);

/* Décode une instruction de type 'blx'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_blx_register(uint16_t raw);

/* Décode une instruction de type 'bx'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_bx(uint16_t raw);

/* Décode une instruction de type 'cbnz'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_cbnz_cbz(uint16_t raw);

/* Décode une instruction de type 'cmn'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_cmn_register(uint16_t raw);

/* Décode une instruction de type 'cmp'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_cmp_immediate(uint16_t raw);

/* Décode une instruction de type 'cmp'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_cmp_register(uint16_t raw);

/* Décode une instruction de type 'eor'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_eor_register(uint16_t raw);

/* Décode une instruction de type 'it'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_it(uint16_t raw);

/* Décode une instruction de type 'ldm'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldm_ldmia_ldmfd_thumb(uint16_t raw);

/* Décode une instruction de type 'ldr'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldr_immediate_thumb(uint16_t raw);

/* Décode une instruction de type 'ldr'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldr_literal(uint16_t raw);

/* Décode une instruction de type 'ldr'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldr_register_thumb(uint16_t raw);

/* Décode une instruction de type 'ldrb'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldrb_immediate_thumb(uint16_t raw);

/* Décode une instruction de type 'ldrb'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldrb_register(uint16_t raw);

/* Décode une instruction de type 'ldrh'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldrh_immediate_thumb(uint16_t raw);

/* Décode une instruction de type 'ldrh'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldrh_register(uint16_t raw);

/* Décode une instruction de type 'ldrsb'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldrsb_register(uint16_t raw);

/* Décode une instruction de type 'ldrsh'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ldrsh_register(uint16_t raw);

/* Décode une instruction de type 'lsl'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_lsl_immediate(uint16_t raw);

/* Décode une instruction de type 'lsl'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_lsl_register(uint16_t raw);

/* Décode une instruction de type 'lsr'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_lsr_immediate(uint16_t raw);

/* Décode une instruction de type 'lsr'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_lsr_register(uint16_t raw);

/* Décode une instruction de type 'mov'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_mov_immediate(uint16_t raw);

/* Décode une instruction de type 'mov'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_mov_register_thumb(uint16_t raw);

/* Décode une instruction de type 'mul'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_mul(uint16_t raw);

/* Décode une instruction de type 'mvn'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_mvn_register(uint16_t raw);

/* Décode une instruction de type 'nop'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_nop(uint16_t raw);

/* Décode une instruction de type 'orr'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_orr_register(uint16_t raw);

/* Décode une instruction de type 'pop'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_pop_thumb(uint16_t raw);

/* Décode une instruction de type 'push'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_push(uint16_t raw);

/* Décode une instruction de type 'rev'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_rev(uint16_t raw);

/* Décode une instruction de type 'rev16'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_rev16(uint16_t raw);

/* Décode une instruction de type 'revsh'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_revsh(uint16_t raw);

/* Décode une instruction de type 'ror'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_ror_register(uint16_t raw);

/* Décode une instruction de type 'rsb'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_rsb_immediate(uint16_t raw);

/* Décode une instruction de type 'sbc'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_sbc_register(uint16_t raw);

/* Décode une instruction de type 'setend'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_setend(uint16_t raw);

/* Décode une instruction de type 'sev'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_sev(uint16_t raw);

/* Décode une instruction de type 'stm'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_stm_stmia_stmea(uint16_t raw);

/* Décode une instruction de type 'str'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_str_immediate_thumb(uint16_t raw);

/* Décode une instruction de type 'str'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_str_register(uint16_t raw);

/* Décode une instruction de type 'strb'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_strb_immediate_thumb(uint16_t raw);

/* Décode une instruction de type 'strb'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_strb_register(uint16_t raw);

/* Décode une instruction de type 'strh'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_strh_immediate_thumb(uint16_t raw);

/* Décode une instruction de type 'strh'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_strh_register(uint16_t raw);

/* Décode une instruction de type 'sub'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_sub_immediate_thumb(uint16_t raw);

/* Décode une instruction de type 'sub'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_sub_register(uint16_t raw);

/* Décode une instruction de type 'sub'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_sub_sp_minus_immediate(uint16_t raw);

/* Décode une instruction de type 'svc'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_svc_previously_swi(uint16_t raw);

/* Décode une instruction de type 'sxtb'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_sxtb(uint16_t raw);

/* Décode une instruction de type 'sxth'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_sxth(uint16_t raw);

/* Décode une instruction de type 'tst'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_tst_register(uint16_t raw);

/* Décode une instruction de type 'udf'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_udf(uint16_t raw);

/* Décode une instruction de type 'uxtb'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_uxtb(uint16_t raw);

/* Décode une instruction de type 'uxth'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_uxth(uint16_t raw);

/* Décode une instruction de type 'wfe'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_wfe(uint16_t raw);

/* Décode une instruction de type 'wfi'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_wfi(uint16_t raw);

/* Décode une instruction de type 'yield'. */
GArchInstruction *armv7_read_thumb_16_instr_a8_yield(uint16_t raw);

/* Décode une instruction de type 'cps'. */
GArchInstruction *armv7_read_thumb_16_instr_b9_cps_thumb(uint16_t raw);



#endif  /* _PLUGINS_ARM_V7_OPCODES_THUMB_16_OPCODES_H */
