
/* Chrysalide - Outil d'analyse de fichiers binaires
 * descriptions.h - définition des descriptions des instructions Dalvik v35
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_DALVIK_V35_OPCODES_DESCRIPTIONS_H
#define _PLUGINS_DALVIK_V35_OPCODES_DESCRIPTIONS_H


#include "identifiers.h"



/* Enumération de tous les mots clefs */
static char *_dalvik35_descriptions[DOP35_COUNT] = {

    [DOP35_NOP] = "Waste cycles.\n\n<b>Note:</b> Data-bearing pseudo-instructions are tagged with this opb, in which case the high-order byte of the opb unit indicates the nature of the data. See \"<b>packed-switch-payload</b> Format\", \"<b>sparse-switch-payload</b> Format\", and \"<b>fill-array-data-payload</b> Format\" below.",
    [DOP35_MOVE] = "Move the contents of one non-object register to another.",
    [DOP35_MOVE_FROM16] = "Move the contents of one non-object register to another.",
    [DOP35_MOVE_16] = "Move the contents of one non-object register to another.",
    [DOP35_MOVE_WIDE] = "Move the contents of one register-pair to another.\n\n<b>Note:</b> It is legal to move from <b>v<i>N</i></b> to either <b>v<i>N-1</i></b> or <b>v<i>N+1</i></b>, so implementations must arrange for both halves of a register pair to be read before anything is written.",
    [DOP35_MOVE_WIDE_FROM16] = "Move the contents of one register-pair to another.\n\n<b>Note:</b> Implementation considerations are the same as <b>move-wide</b>, above.",
    [DOP35_MOVE_WIDE_16] = "Move the contents of one register-pair to another.\n\n<b>Note:</b> Implementation considerations are the same as <b>move-wide</b>, above.",
    [DOP35_MOVE_OBJECT] = "Move the contents of one object-bearing register to another.",
    [DOP35_MOVE_OBJECT_FROM16] = "Move the contents of one object-bearing register to another.",
    [DOP35_MOVE_OBJECT_16] = "Move the contents of one object-bearing register to another.",
    [DOP35_MOVE_RESULT] = "Move the single-word non-object result of the most recent <b>invoke-<i>kind</i></b> into the indicated register. This must be done as the instruction immediately after an <b>invoke-<i>kind</i></b> whose (single-word, non-object) result is not to be ignored; anywhere else is invalid.",
    [DOP35_MOVE_RESULT_WIDE] = "Move the double-word result of the most recent <b>invoke-<i>kind</i></b> into the indicated register pair. This must be done as the instruction immediately after an <b>invoke-<i>kind</i></b> whose (double-word) result is not to be ignored; anywhere else is invalid.",
    [DOP35_MOVE_RESULT_OBJECT] = "Move the object result of the most recent <b>invoke-<i>kind</i></b> into the indicated register. This must be done as the instruction immediately after an <b>invoke-<i>kind</i></b> or <b>filled-new-array</b> whose (object) result is not to be ignored; anywhere else is invalid.",
    [DOP35_MOVE_EXCEPTION] = "Save a just-caught exception into the given register. This must be the first instruction of any exception handler whose caught exception is not to be ignored, and this instruction must <i>only</i> ever occur as the first instruction of an exception handler; anywhere else is invalid.",
    [DOP35_RETURN_VOID] = "Return from a <b>void</b> method.",
    [DOP35_RETURN] = "Return from a single-width (32-bit) non-object value-returning method.",
    [DOP35_RETURN_WIDE] = "Return from a double-width (64-bit) value-returning method.",
    [DOP35_RETURN_OBJECT] = "Return from an object-returning method.",
    [DOP35_CONST_4] = "Move the given literal value (sign-extended to 32 bits) into the specified register.",
    [DOP35_CONST_16] = "Move the given literal value (sign-extended to 32 bits) into the specified register.",
    [DOP35_CONST] = "Move the given literal value into the specified register.",
    [DOP35_CONST_HIGH16] = "Move the given literal value (right-zero-extended to 32 bits) into the specified register.",
    [DOP35_CONST_WIDE_16] = "Move the given literal value (sign-extended to 64 bits) into the specified register-pair.",
    [DOP35_CONST_WIDE_32] = "Move the given literal value (sign-extended to 64 bits) into the specified register-pair.",
    [DOP35_CONST_WIDE] = "Move the given literal value into the specified register-pair.",
    [DOP35_CONST_WIDE_HIGH16] = "Move the given literal value (right-zero-extended to 64 bits) into the specified register-pair.",
    [DOP35_CONST_STRING] = "Move a reference to the string specified by the given index into the specified register.",
    [DOP35_CONST_STRING_JUMBO] = "Move a reference to the string specified by the given index into the specified register.",
    [DOP35_CONST_CLASS] = "Move a reference to the class specified by the given index into the specified register. In the case where the indicated type is primitive, this will store a reference to the primitive type's degenerate class.",
    [DOP35_MONITOR_ENTER] = "Acquire the monitor for the indicated object.",
    [DOP35_MONITOR_EXIT] = "Release the monitor for the indicated object.\n\n<b>Note:</b> If this instruction needs to throw an exception, it must do so as if the pc has already advanced past the instruction. It may be useful to think of this as the instruction successfully executing (in a sense), and the exception getting thrown <i>after</i> the instruction but <i>before</i> the next one gets a chance to run. This definition makes it possible for a method to use a monitor cleanup catch-all (e.g., <b>finally</b>) block as the monitor cleanup for that block itself, as a way to handle the arbitrary exceptions that might get thrown due to the historical implementation of <b>Thread.stop()</b>, while still managing to have proper monitor hygiene.",
    [DOP35_CHECK_CAST] = "Throw a <b>ClassCastException</b> if the reference in the given register cannot be cast to the indicated type.\n\n<b>Note:</b> Since <b>A</b> must always be a reference (and not a primitive value), this will necessarily fail at runtime (that is, it will throw an exception) if <b>B</b> refers to a primitive type.",
    [DOP35_INSTANCE_OF] = "Store in the given destination register <b>1</b> if the indicated reference is an instance of the given type, or <b>0</b> if not.\n\n<b>Note:</b> Since <b>B</b> must always be a reference (and not a primitive value), this will always result in <b>0</b> being stored if <b>C</b> refers to a primitive type.",
    [DOP35_ARRAY_LENGTH] = "Store in the given destination register the length of the indicated array, in entries",
    [DOP35_NEW_INSTANCE] = "Construct a new instance of the indicated type, storing a reference to it in the destination. The type must refer to a non-array class.",
    [DOP35_NEW_ARRAY] = "Construct a new array of the indicated type and size. The type must be an array type.",
    [DOP35_FILLED_NEW_ARRAY] = "Construct an array of the given type and size, filling it with the supplied contents. The type must be an array type. The array's contents must be single-word (that is, no arrays of <b>long</b> or <b>double</b>, but reference types are acceptable). The constructed instance is stored as a \"result\" in the same way that the method invocation instructions store their results, so the constructed instance must be moved to a register with an immediately subsequent <b>move-result-object</b> instruction (if it is to be used).",
    [DOP35_FILLED_NEW_ARRAY_RANGE] = "Construct an array of the given type and size, filling it with the supplied contents. Clarifications and restrictions are the same as <b>filled-new-array</b>, described above.",
    [DOP35_FILL_ARRAY_DATA] = "Fill the given array with the indicated data. The reference must be to an array of primitives, and the data table must match it in type and must contain no more elements than will fit in the array. That is, the array may be larger than the table, and if so, only the initial elements of the array are set, leaving the remainder alone.",
    [DOP35_THROW] = "Throw the indicated exception.",
    [DOP35_GOTO] = "Unconditionally jump to the indicated instruction.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either with <b>goto/32</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_GOTO_16] = "Unconditionally jump to the indicated instruction.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either with <b>goto/32</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_GOTO_32] = "Unconditionally jump to the indicated instruction.",
    [DOP35_PACKED_SWITCH] = "Jump to a new instruction based on the value in the given register, using a table of offsets corresponding to each value in a particular integral range, or fall through to the next instruction if there is no match.",
    [DOP35_SPARSE_SWITCH] = "Jump to a new instruction based on the value in the given register, using an ordered table of value-offset pairs, or fall through to the next instruction if there is no match.",
    [DOP35_CMPL_FLOAT] = "Perform the indicated floating point or <b>long</b> comparison, setting <b>a</b> to <b>0</b> if <b>b == c</b>, <b>1</b> if <b>b &gt; c</b>, or <b>-1</b> if <b>b &lt; c</b>. The \"bias\" listed for the floating point operations indicates how <b>NaN</b> comparisons are treated: \"gt bias\" instructions return <b>1</b> for <b>NaN</b> comparisons, and \"lt bias\" instructions return <b>-1</b>.\n\nFor example, to check to see if floating point <b>x &lt; y</b> it is advisable to use <b>cmpg-float</b>; a result of <b>-1</b> indicates that the test was true, and the other values indicate it was false either due to a valid comparison or because one of the values was <b>NaN</b>.",
    [DOP35_CMPG_FLOAT] = "Perform the indicated floating point or <b>long</b> comparison, setting <b>a</b> to <b>0</b> if <b>b == c</b>, <b>1</b> if <b>b &gt; c</b>, or <b>-1</b> if <b>b &lt; c</b>. The \"bias\" listed for the floating point operations indicates how <b>NaN</b> comparisons are treated: \"gt bias\" instructions return <b>1</b> for <b>NaN</b> comparisons, and \"lt bias\" instructions return <b>-1</b>.\n\nFor example, to check to see if floating point <b>x &lt; y</b> it is advisable to use <b>cmpg-float</b>; a result of <b>-1</b> indicates that the test was true, and the other values indicate it was false either due to a valid comparison or because one of the values was <b>NaN</b>.",
    [DOP35_CMPL_DOUBLE] = "Perform the indicated floating point or <b>long</b> comparison, setting <b>a</b> to <b>0</b> if <b>b == c</b>, <b>1</b> if <b>b &gt; c</b>, or <b>-1</b> if <b>b &lt; c</b>. The \"bias\" listed for the floating point operations indicates how <b>NaN</b> comparisons are treated: \"gt bias\" instructions return <b>1</b> for <b>NaN</b> comparisons, and \"lt bias\" instructions return <b>-1</b>.\n\nFor example, to check to see if floating point <b>x &lt; y</b> it is advisable to use <b>cmpg-float</b>; a result of <b>-1</b> indicates that the test was true, and the other values indicate it was false either due to a valid comparison or because one of the values was <b>NaN</b>.",
    [DOP35_CMPG_DOUBLE] = "Perform the indicated floating point or <b>long</b> comparison, setting <b>a</b> to <b>0</b> if <b>b == c</b>, <b>1</b> if <b>b &gt; c</b>, or <b>-1</b> if <b>b &lt; c</b>. The \"bias\" listed for the floating point operations indicates how <b>NaN</b> comparisons are treated: \"gt bias\" instructions return <b>1</b> for <b>NaN</b> comparisons, and \"lt bias\" instructions return <b>-1</b>.\n\nFor example, to check to see if floating point <b>x &lt; y</b> it is advisable to use <b>cmpg-float</b>; a result of <b>-1</b> indicates that the test was true, and the other values indicate it was false either due to a valid comparison or because one of the values was <b>NaN</b>.",
    [DOP35_CMP_LONG] = "Perform the indicated floating point or <b>long</b> comparison, setting <b>a</b> to <b>0</b> if <b>b == c</b>, <b>1</b> if <b>b &gt; c</b>, or <b>-1</b> if <b>b &lt; c</b>. The \"bias\" listed for the floating point operations indicates how <b>NaN</b> comparisons are treated: \"gt bias\" instructions return <b>1</b> for <b>NaN</b> comparisons, and \"lt bias\" instructions return <b>-1</b>.\n\nFor example, to check to see if floating point <b>x &lt; y</b> it is advisable to use <b>cmpg-float</b>; a result of <b>-1</b> indicates that the test was true, and the other values indicate it was false either due to a valid comparison or because one of the values was <b>NaN</b>.",
    [DOP35_IF_EQ] = "Branch to the given destination if the given two registers' values compare as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_NE] = "Branch to the given destination if the given two registers' values compare as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_LT] = "Branch to the given destination if the given two registers' values compare as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_GE] = "Branch to the given destination if the given two registers' values compare as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_GT] = "Branch to the given destination if the given two registers' values compare as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_LE] = "Branch to the given destination if the given two registers' values compare as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_EQZ] = "Branch to the given destination if the given register's value compares with 0 as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_NEZ] = "Branch to the given destination if the given register's value compares with 0 as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_LTZ] = "Branch to the given destination if the given register's value compares with 0 as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_GEZ] = "Branch to the given destination if the given register's value compares with 0 as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_GTZ] = "Branch to the given destination if the given register's value compares with 0 as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_IF_LEZ] = "Branch to the given destination if the given register's value compares with 0 as specified.\n\n<b>Note:</b> The branch offset must not be <b>0</b>. (A spin loop may be legally constructed either by branching around a backward <b>goto</b> or by including a <b>nop</b> as a target before the branch.)",
    [DOP35_AGET] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_AGET_WIDE] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_AGET_OBJECT] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_AGET_BOOLEAN] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_AGET_BYTE] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_AGET_CHAR] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_AGET_SHORT] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_APUT] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_APUT_WIDE] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_APUT_OBJECT] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_APUT_BOOLEAN] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_APUT_BYTE] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_APUT_CHAR] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_APUT_SHORT] = "Perform the identified array operation at the identified index of the given array, loading or storing into the value register.",
    [DOP35_IGET] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IGET_WIDE] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IGET_OBJECT] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IGET_BOOLEAN] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IGET_BYTE] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IGET_CHAR] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IGET_SHORT] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IPUT] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IPUT_WIDE] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IPUT_OBJECT] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IPUT_BOOLEAN] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IPUT_BYTE] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IPUT_CHAR] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_IPUT_SHORT] = "Perform the identified object instance field operation with the identified field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SGET] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SGET_WIDE] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SGET_OBJECT] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SGET_BOOLEAN] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SGET_BYTE] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SGET_CHAR] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SGET_SHORT] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SPUT] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SPUT_WIDE] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SPUT_OBJECT] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SPUT_BOOLEAN] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SPUT_BYTE] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SPUT_CHAR] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_SPUT_SHORT] = "Perform the identified object static field operation with the identified static field, loading or storing into the value register.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the field argument to be a more direct offset.",
    [DOP35_INVOKE_VIRTUAL] = "Call the indicated method. The result (if any) may be stored with an appropriate <b>move-result*</b> variant as the immediately subsequent instruction.\n\n<b>invoke-virtual</b> is used to invoke a normal virtual method (a method that is not <b>private</b>, <b>static</b>, or <b>final</b>, and is also not a constructor).\n\nWhen the <b>method_id</b> references a method of a non-interface class, <b>invoke-super</b> is used to invoke the closest superclass's virtual method (as opposed to the one with the same <b>method_id</b> in the calling class). The same method restrictions hold as for <b>invoke-virtual</b>.\n\nIn Dex files version <b>037</b> or later, if the <b>method_id</b> refers to an interface method, <b>invoke-super</b> is used to invoke the most specific, non-overridden version of that method defined on that interface. The same method restrictions hold as for <b>invoke-virtual</b>. In Dex files prior to version <b>037</b>, having an interface <b>method_id</b> is illegal and undefined.\n\n<b>invoke-direct</b> is used to invoke a non-<b>static</b> direct method (that is, an instance method that is by its nature non-overridable, namely either a <b>private</b> instance method or a constructor).\n\n<b>invoke-static</b> is used to invoke a <b>static</b> method (which is always considered a direct method).\n\n<b>invoke-interface</b> is used to invoke an <b>interface</b> method, that is, on an object whose concrete class isn't known, using a <b>method_id</b> that refers to an <b>interface</b>.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the method argument to be a more direct offset (or pair thereof).",
    [DOP35_INVOKE_SUPER] = "Call the indicated method. The result (if any) may be stored with an appropriate <b>move-result*</b> variant as the immediately subsequent instruction.\n\n<b>invoke-virtual</b> is used to invoke a normal virtual method (a method that is not <b>private</b>, <b>static</b>, or <b>final</b>, and is also not a constructor).\n\nWhen the <b>method_id</b> references a method of a non-interface class, <b>invoke-super</b> is used to invoke the closest superclass's virtual method (as opposed to the one with the same <b>method_id</b> in the calling class). The same method restrictions hold as for <b>invoke-virtual</b>.\n\nIn Dex files version <b>037</b> or later, if the <b>method_id</b> refers to an interface method, <b>invoke-super</b> is used to invoke the most specific, non-overridden version of that method defined on that interface. The same method restrictions hold as for <b>invoke-virtual</b>. In Dex files prior to version <b>037</b>, having an interface <b>method_id</b> is illegal and undefined.\n\n<b>invoke-direct</b> is used to invoke a non-<b>static</b> direct method (that is, an instance method that is by its nature non-overridable, namely either a <b>private</b> instance method or a constructor).\n\n<b>invoke-static</b> is used to invoke a <b>static</b> method (which is always considered a direct method).\n\n<b>invoke-interface</b> is used to invoke an <b>interface</b> method, that is, on an object whose concrete class isn't known, using a <b>method_id</b> that refers to an <b>interface</b>.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the method argument to be a more direct offset (or pair thereof).",
    [DOP35_INVOKE_DIRECT] = "Call the indicated method. The result (if any) may be stored with an appropriate <b>move-result*</b> variant as the immediately subsequent instruction.\n\n<b>invoke-virtual</b> is used to invoke a normal virtual method (a method that is not <b>private</b>, <b>static</b>, or <b>final</b>, and is also not a constructor).\n\nWhen the <b>method_id</b> references a method of a non-interface class, <b>invoke-super</b> is used to invoke the closest superclass's virtual method (as opposed to the one with the same <b>method_id</b> in the calling class). The same method restrictions hold as for <b>invoke-virtual</b>.\n\nIn Dex files version <b>037</b> or later, if the <b>method_id</b> refers to an interface method, <b>invoke-super</b> is used to invoke the most specific, non-overridden version of that method defined on that interface. The same method restrictions hold as for <b>invoke-virtual</b>. In Dex files prior to version <b>037</b>, having an interface <b>method_id</b> is illegal and undefined.\n\n<b>invoke-direct</b> is used to invoke a non-<b>static</b> direct method (that is, an instance method that is by its nature non-overridable, namely either a <b>private</b> instance method or a constructor).\n\n<b>invoke-static</b> is used to invoke a <b>static</b> method (which is always considered a direct method).\n\n<b>invoke-interface</b> is used to invoke an <b>interface</b> method, that is, on an object whose concrete class isn't known, using a <b>method_id</b> that refers to an <b>interface</b>.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the method argument to be a more direct offset (or pair thereof).",
    [DOP35_INVOKE_STATIC] = "Call the indicated method. The result (if any) may be stored with an appropriate <b>move-result*</b> variant as the immediately subsequent instruction.\n\n<b>invoke-virtual</b> is used to invoke a normal virtual method (a method that is not <b>private</b>, <b>static</b>, or <b>final</b>, and is also not a constructor).\n\nWhen the <b>method_id</b> references a method of a non-interface class, <b>invoke-super</b> is used to invoke the closest superclass's virtual method (as opposed to the one with the same <b>method_id</b> in the calling class). The same method restrictions hold as for <b>invoke-virtual</b>.\n\nIn Dex files version <b>037</b> or later, if the <b>method_id</b> refers to an interface method, <b>invoke-super</b> is used to invoke the most specific, non-overridden version of that method defined on that interface. The same method restrictions hold as for <b>invoke-virtual</b>. In Dex files prior to version <b>037</b>, having an interface <b>method_id</b> is illegal and undefined.\n\n<b>invoke-direct</b> is used to invoke a non-<b>static</b> direct method (that is, an instance method that is by its nature non-overridable, namely either a <b>private</b> instance method or a constructor).\n\n<b>invoke-static</b> is used to invoke a <b>static</b> method (which is always considered a direct method).\n\n<b>invoke-interface</b> is used to invoke an <b>interface</b> method, that is, on an object whose concrete class isn't known, using a <b>method_id</b> that refers to an <b>interface</b>.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the method argument to be a more direct offset (or pair thereof).",
    [DOP35_INVOKE_INTERFACE] = "Call the indicated method. The result (if any) may be stored with an appropriate <b>move-result*</b> variant as the immediately subsequent instruction.\n\n<b>invoke-virtual</b> is used to invoke a normal virtual method (a method that is not <b>private</b>, <b>static</b>, or <b>final</b>, and is also not a constructor).\n\nWhen the <b>method_id</b> references a method of a non-interface class, <b>invoke-super</b> is used to invoke the closest superclass's virtual method (as opposed to the one with the same <b>method_id</b> in the calling class). The same method restrictions hold as for <b>invoke-virtual</b>.\n\nIn Dex files version <b>037</b> or later, if the <b>method_id</b> refers to an interface method, <b>invoke-super</b> is used to invoke the most specific, non-overridden version of that method defined on that interface. The same method restrictions hold as for <b>invoke-virtual</b>. In Dex files prior to version <b>037</b>, having an interface <b>method_id</b> is illegal and undefined.\n\n<b>invoke-direct</b> is used to invoke a non-<b>static</b> direct method (that is, an instance method that is by its nature non-overridable, namely either a <b>private</b> instance method or a constructor).\n\n<b>invoke-static</b> is used to invoke a <b>static</b> method (which is always considered a direct method).\n\n<b>invoke-interface</b> is used to invoke an <b>interface</b> method, that is, on an object whose concrete class isn't known, using a <b>method_id</b> that refers to an <b>interface</b>.\n\n<b>Note:</b> These opbs are reasonable candidates for static linking, altering the method argument to be a more direct offset (or pair thereof).",
    [DOP35_INVOKE_VIRTUAL_RANGE] = "Call the indicated method. See first <b>invoke-<i>kind</i></b> description above for details, caveats, and suggestions.",
    [DOP35_INVOKE_SUPER_RANGE] = "Call the indicated method. See first <b>invoke-<i>kind</i></b> description above for details, caveats, and suggestions.",
    [DOP35_INVOKE_DIRECT_RANGE] = "Call the indicated method. See first <b>invoke-<i>kind</i></b> description above for details, caveats, and suggestions.",
    [DOP35_INVOKE_STATIC_RANGE] = "Call the indicated method. See first <b>invoke-<i>kind</i></b> description above for details, caveats, and suggestions.",
    [DOP35_INVOKE_INTERFACE_RANGE] = "Call the indicated method. See first <b>invoke-<i>kind</i></b> description above for details, caveats, and suggestions.",
    [DOP35_NEG_INT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_NOT_INT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_NEG_LONG] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_NOT_LONG] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_NEG_FLOAT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_NEG_DOUBLE] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_INT_TO_LONG] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_INT_TO_FLOAT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_INT_TO_DOUBLE] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_LONG_TO_INT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_LONG_TO_FLOAT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_LONG_TO_DOUBLE] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_FLOAT_TO_INT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_FLOAT_TO_LONG] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_FLOAT_TO_DOUBLE] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_DOUBLE_TO_INT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_DOUBLE_TO_LONG] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_DOUBLE_TO_FLOAT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_INT_TO_BYTE] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_INT_TO_CHAR] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_INT_TO_SHORT] = "Perform the identified unary operation on the source register, storing the result in the destination register.",
    [DOP35_ADD_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SUB_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_MUL_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_DIV_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_REM_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_AND_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_OR_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_XOR_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SHL_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SHR_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_USHR_INT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_ADD_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SUB_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_MUL_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_DIV_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_REM_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_AND_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_OR_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_XOR_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SHL_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SHR_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_USHR_LONG] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_ADD_FLOAT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SUB_FLOAT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_MUL_FLOAT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_DIV_FLOAT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_REM_FLOAT] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_ADD_DOUBLE] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SUB_DOUBLE] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_MUL_DOUBLE] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_DIV_DOUBLE] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_REM_DOUBLE] = "Perform the identified binary operation on the two source registers, storing the result in the destination register.\n\n<b>Note:</b> Contrary to other <b>-long</b> mathematical operations (which take register pairs for both their first and their second source), <b>shl-long</b>, <b>shr-long</b>, and <b>ushr-long</b> take a register pair for their first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_ADD_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SUB_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_MUL_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_DIV_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_REM_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_AND_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_OR_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_XOR_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SHL_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SHR_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_USHR_INT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_ADD_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SUB_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_MUL_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_DIV_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_REM_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_AND_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_OR_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_XOR_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SHL_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SHR_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_USHR_LONG_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_ADD_FLOAT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SUB_FLOAT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_MUL_FLOAT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_DIV_FLOAT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_REM_FLOAT_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_ADD_DOUBLE_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_SUB_DOUBLE_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_MUL_DOUBLE_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_DIV_DOUBLE_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_REM_DOUBLE_2ADDR] = "Perform the identified binary operation on the two source registers, storing the result in the first source register.\n\n<b>Note:</b> Contrary to other <b>-long/2addr</b> mathematical operations (which take register pairs for both their destination/first source and their second source), <b>shl-long/2addr</b>, <b>shr-long/2addr</b>, and <b>ushr-long/2addr</b> take a register pair for their destination/first source (the value to be shifted), but a single register for their second source (the shifting distance).",
    [DOP35_ADD_INT_LIT16] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> <b>rsub-int</b> does not have a suffix since this version is the main opb of its family. Also, see below for details on its semantics.",
    [DOP35_RSUB_INT] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> <b>rsub-int</b> does not have a suffix since this version is the main opb of its family. Also, see below for details on its semantics.",
    [DOP35_MUL_INT_LIT16] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> <b>rsub-int</b> does not have a suffix since this version is the main opb of its family. Also, see below for details on its semantics.",
    [DOP35_DIV_INT_LIT16] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> <b>rsub-int</b> does not have a suffix since this version is the main opb of its family. Also, see below for details on its semantics.",
    [DOP35_REM_INT_LIT16] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> <b>rsub-int</b> does not have a suffix since this version is the main opb of its family. Also, see below for details on its semantics.",
    [DOP35_AND_INT_LIT16] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> <b>rsub-int</b> does not have a suffix since this version is the main opb of its family. Also, see below for details on its semantics.",
    [DOP35_OR_INT_LIT16] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> <b>rsub-int</b> does not have a suffix since this version is the main opb of its family. Also, see below for details on its semantics.",
    [DOP35_XOR_INT_LIT16] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> <b>rsub-int</b> does not have a suffix since this version is the main opb of its family. Also, see below for details on its semantics.",
    [DOP35_ADD_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_RSUB_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_MUL_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_DIV_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_REM_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_AND_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_OR_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_XOR_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_SHL_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_SHR_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",
    [DOP35_USHR_INT_LIT8] = "Perform the indicated binary op on the indicated register (first argument) and literal value (second argument), storing the result in the destination register.\n\n<b>Note:</b> See below for details on the semantics of <b>rsub-int</b>.",

};



#endif  /* _PLUGINS_DALVIK_V35_OPCODES_DESCRIPTIONS_H */
