
/* Chrysalide - Outil d'analyse de fichiers binaires
 * hooks.h - définition des décrochages pour instructions Dalvik v35
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_DALVIK_V35_OPCODES_HOOKS_H
#define _PLUGINS_DALVIK_V35_OPCODES_HOOKS_H


#include "identifiers.h"


#include "../../fetch.h" 
#include "../../link.h" 
#include "../../post.h"



/* Définitions des décrochages pour l'établissement d'instructions */
static const instr_hook_fc _dalvik35_hooks[DOP35_COUNT][IPH_COUNT] = {

    [DOP35_CONST_STRING] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_for_dalvik_string,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_CONST_STRING_JUMBO] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_for_dalvik_string,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_FILL_ARRAY_DATA] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_fill_array_data_instruction,
        [IPH_LINK] = (instr_hook_fc)NULL,
        [IPH_POST] = (instr_hook_fc)post_process_data_payload_references,
    },
    [DOP35_GOTO] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_goto_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_jump_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_goto_target_resolution,
    },
    [DOP35_GOTO_16] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_goto_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_jump_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_goto_target_resolution,
    },
    [DOP35_GOTO_32] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_goto_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_jump_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_goto_target_resolution,
    },
    [DOP35_PACKED_SWITCH] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_packed_switch_links,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_SPARSE_SWITCH] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_packed_switch_links,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_IF_EQ] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_if_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_if_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_if_target_resolution,
    },
    [DOP35_IF_NE] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_if_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_if_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_if_target_resolution,
    },
    [DOP35_IF_LT] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_if_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_if_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_if_target_resolution,
    },
    [DOP35_IF_GE] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_if_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_if_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_if_target_resolution,
    },
    [DOP35_IF_GT] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_if_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_if_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_if_target_resolution,
    },
    [DOP35_IF_LE] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_if_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_if_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_if_target_resolution,
    },
    [DOP35_IF_EQZ] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_ifz_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_ifz_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_ifz_target_resolution,
    },
    [DOP35_IF_NEZ] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_ifz_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_ifz_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_ifz_target_resolution,
    },
    [DOP35_IF_LTZ] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_ifz_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_ifz_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_ifz_target_resolution,
    },
    [DOP35_IF_GEZ] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_ifz_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_ifz_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_ifz_target_resolution,
    },
    [DOP35_IF_GTZ] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_ifz_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_ifz_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_ifz_target_resolution,
    },
    [DOP35_IF_LEZ] = {
        [IPH_FETCH] = (instr_hook_fc)help_fetching_with_dalvik_ifz_instruction,
        [IPH_LINK] = (instr_hook_fc)handle_dalvik_ifz_branch_as_link,
        [IPH_POST] = (instr_hook_fc)post_process_dalvik_ifz_target_resolution,
    },
    [DOP35_INVOKE_VIRTUAL] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_INVOKE_SUPER] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_INVOKE_DIRECT] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_INVOKE_STATIC] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_INVOKE_INTERFACE] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_INVOKE_VIRTUAL_RANGE] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_INVOKE_SUPER_RANGE] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_INVOKE_DIRECT_RANGE] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_INVOKE_STATIC_RANGE] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },
    [DOP35_INVOKE_INTERFACE_RANGE] = {
        [IPH_FETCH] = (instr_hook_fc)NULL,
        [IPH_LINK] = (instr_hook_fc)handle_links_between_caller_and_callee,
        [IPH_POST] = (instr_hook_fc)NULL,
    },

};



#endif  /* _PLUGINS_DALVIK_V35_OPCODES_HOOKS_H */
