
/* Chrysalide - Outil d'analyse de fichiers binaires
 * identifiers.h - définition des identifiants uniques pour Dalvik v35
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_DALVIK_V35_OPCODES_IDENTIFIERS_H
#define _PLUGINS_DALVIK_V35_OPCODES_IDENTIFIERS_H


/* Enumération de tous les opcodes */
typedef enum _Dalvik35Opcodes
{
    DOP35_NOP,                              /* nop (0x00)                  */
    DOP35_MOVE,                             /* move (0x01)                 */
    DOP35_MOVE_FROM16,                      /* move/from16 (0x02)          */
    DOP35_MOVE_16,                          /* move/16 (0x03)              */
    DOP35_MOVE_WIDE,                        /* move-wide (0x04)            */
    DOP35_MOVE_WIDE_FROM16,                 /* move-wide/from16 (0x05)     */
    DOP35_MOVE_WIDE_16,                     /* move-wide/16 (0x06)         */
    DOP35_MOVE_OBJECT,                      /* move-object (0x07)          */
    DOP35_MOVE_OBJECT_FROM16,               /* move-object/from16 (0x08)   */
    DOP35_MOVE_OBJECT_16,                   /* move-object/16 (0x09)       */
    DOP35_MOVE_RESULT,                      /* move-result (0x0a)          */
    DOP35_MOVE_RESULT_WIDE,                 /* move-result-wide (0x0b)     */
    DOP35_MOVE_RESULT_OBJECT,               /* move-result-object (0x0c)   */
    DOP35_MOVE_EXCEPTION,                   /* move-exception (0x0d)       */
    DOP35_RETURN_VOID,                      /* return-void (0x0e)          */
    DOP35_RETURN,                           /* return (0x0f)               */
    DOP35_RETURN_WIDE,                      /* return-wide (0x10)          */
    DOP35_RETURN_OBJECT,                    /* return-object (0x11)        */
    DOP35_CONST_4,                          /* const/4 (0x12)              */
    DOP35_CONST_16,                         /* const/16 (0x13)             */
    DOP35_CONST,                            /* const (0x14)                */
    DOP35_CONST_HIGH16,                     /* const/high16 (0x15)         */
    DOP35_CONST_WIDE_16,                    /* const-wide/16 (0x16)        */
    DOP35_CONST_WIDE_32,                    /* const-wide/32 (0x17)        */
    DOP35_CONST_WIDE,                       /* const-wide (0x18)           */
    DOP35_CONST_WIDE_HIGH16,                /* const-wide/high16 (0x19)    */
    DOP35_CONST_STRING,                     /* const-string (0x1a)         */
    DOP35_CONST_STRING_JUMBO,               /* const-string/jumbo (0x1b)   */
    DOP35_CONST_CLASS,                      /* const-class (0x1c)          */
    DOP35_MONITOR_ENTER,                    /* monitor-enter (0x1d)        */
    DOP35_MONITOR_EXIT,                     /* monitor-exit (0x1e)         */
    DOP35_CHECK_CAST,                       /* check-cast (0x1f)           */
    DOP35_INSTANCE_OF,                      /* instance-of (0x20)          */
    DOP35_ARRAY_LENGTH,                     /* array-length (0x21)         */
    DOP35_NEW_INSTANCE,                     /* new-instance (0x22)         */
    DOP35_NEW_ARRAY,                        /* new-array (0x23)            */
    DOP35_FILLED_NEW_ARRAY,                 /* filled-new-array (0x24)     */
    DOP35_FILLED_NEW_ARRAY_RANGE,           /* filled-new-array/range (0x25)*/
    DOP35_FILL_ARRAY_DATA,                  /* fill-array-data (0x26)      */
    DOP35_THROW,                            /* throw (0x27)                */
    DOP35_GOTO,                             /* goto (0x28)                 */
    DOP35_GOTO_16,                          /* goto/16 (0x29)              */
    DOP35_GOTO_32,                          /* goto/32 (0x2a)              */
    DOP35_PACKED_SWITCH,                    /* packed-switch (0x2b)        */
    DOP35_SPARSE_SWITCH,                    /* sparse-switch (0x2c)        */
    DOP35_CMPL_FLOAT,                       /* cmpl-float (0x2d)           */
    DOP35_CMPG_FLOAT,                       /* cmpg-float (0x2e)           */
    DOP35_CMPL_DOUBLE,                      /* cmpl-double (0x2f)          */
    DOP35_CMPG_DOUBLE,                      /* cmpg-double (0x30)          */
    DOP35_CMP_LONG,                         /* cmp-long (0x31)             */
    DOP35_IF_EQ,                            /* if-eq (0x32)                */
    DOP35_IF_NE,                            /* if-ne (0x33)                */
    DOP35_IF_LT,                            /* if-lt (0x34)                */
    DOP35_IF_GE,                            /* if-ge (0x35)                */
    DOP35_IF_GT,                            /* if-gt (0x36)                */
    DOP35_IF_LE,                            /* if-le (0x37)                */
    DOP35_IF_EQZ,                           /* if-eqz (0x38)               */
    DOP35_IF_NEZ,                           /* if-nez (0x39)               */
    DOP35_IF_LTZ,                           /* if-ltz (0x3a)               */
    DOP35_IF_GEZ,                           /* if-gez (0x3b)               */
    DOP35_IF_GTZ,                           /* if-gtz (0x3c)               */
    DOP35_IF_LEZ,                           /* if-lez (0x3d)               */
    DOP35_UNUSED_3E,                        /* unused-3e (0x3e)            */
    DOP35_UNUSED_3F,                        /* unused-3f (0x3f)            */
    DOP35_UNUSED_40,                        /* unused-40 (0x40)            */
    DOP35_UNUSED_41,                        /* unused-41 (0x41)            */
    DOP35_UNUSED_42,                        /* unused-42 (0x42)            */
    DOP35_UNUSED_43,                        /* unused-43 (0x43)            */
    DOP35_AGET,                             /* aget (0x44)                 */
    DOP35_AGET_WIDE,                        /* aget-wide (0x45)            */
    DOP35_AGET_OBJECT,                      /* aget-object (0x46)          */
    DOP35_AGET_BOOLEAN,                     /* aget-boolean (0x47)         */
    DOP35_AGET_BYTE,                        /* aget-byte (0x48)            */
    DOP35_AGET_CHAR,                        /* aget-char (0x49)            */
    DOP35_AGET_SHORT,                       /* aget-short (0x4a)           */
    DOP35_APUT,                             /* aput (0x4b)                 */
    DOP35_APUT_WIDE,                        /* aput-wide (0x4c)            */
    DOP35_APUT_OBJECT,                      /* aput-object (0x4d)          */
    DOP35_APUT_BOOLEAN,                     /* aput-boolean (0x4e)         */
    DOP35_APUT_BYTE,                        /* aput-byte (0x4f)            */
    DOP35_APUT_CHAR,                        /* aput-char (0x50)            */
    DOP35_APUT_SHORT,                       /* aput-short (0x51)           */
    DOP35_IGET,                             /* iget (0x52)                 */
    DOP35_IGET_WIDE,                        /* iget-wide (0x53)            */
    DOP35_IGET_OBJECT,                      /* iget-object (0x54)          */
    DOP35_IGET_BOOLEAN,                     /* iget-boolean (0x55)         */
    DOP35_IGET_BYTE,                        /* iget-byte (0x56)            */
    DOP35_IGET_CHAR,                        /* iget-char (0x57)            */
    DOP35_IGET_SHORT,                       /* iget-short (0x58)           */
    DOP35_IPUT,                             /* iput (0x59)                 */
    DOP35_IPUT_WIDE,                        /* iput-wide (0x5a)            */
    DOP35_IPUT_OBJECT,                      /* iput-object (0x5b)          */
    DOP35_IPUT_BOOLEAN,                     /* iput-boolean (0x5c)         */
    DOP35_IPUT_BYTE,                        /* iput-byte (0x5d)            */
    DOP35_IPUT_CHAR,                        /* iput-char (0x5e)            */
    DOP35_IPUT_SHORT,                       /* iput-short (0x5f)           */
    DOP35_SGET,                             /* sget (0x60)                 */
    DOP35_SGET_WIDE,                        /* sget-wide (0x61)            */
    DOP35_SGET_OBJECT,                      /* sget-object (0x62)          */
    DOP35_SGET_BOOLEAN,                     /* sget-boolean (0x63)         */
    DOP35_SGET_BYTE,                        /* sget-byte (0x64)            */
    DOP35_SGET_CHAR,                        /* sget-char (0x65)            */
    DOP35_SGET_SHORT,                       /* sget-short (0x66)           */
    DOP35_SPUT,                             /* sput (0x67)                 */
    DOP35_SPUT_WIDE,                        /* sput-wide (0x68)            */
    DOP35_SPUT_OBJECT,                      /* sput-object (0x69)          */
    DOP35_SPUT_BOOLEAN,                     /* sput-boolean (0x6a)         */
    DOP35_SPUT_BYTE,                        /* sput-byte (0x6b)            */
    DOP35_SPUT_CHAR,                        /* sput-char (0x6c)            */
    DOP35_SPUT_SHORT,                       /* sput-short (0x6d)           */
    DOP35_INVOKE_VIRTUAL,                   /* invoke-virtual (0x6e)       */
    DOP35_INVOKE_SUPER,                     /* invoke-super (0x6f)         */
    DOP35_INVOKE_DIRECT,                    /* invoke-direct (0x70)        */
    DOP35_INVOKE_STATIC,                    /* invoke-static (0x71)        */
    DOP35_INVOKE_INTERFACE,                 /* invoke-interface (0x72)     */
    DOP35_UNUSED_73,                        /* unused-73 (0x73)            */
    DOP35_INVOKE_VIRTUAL_RANGE,             /* invoke-virtual/range (0x74) */
    DOP35_INVOKE_SUPER_RANGE,               /* invoke-super/range (0x75)   */
    DOP35_INVOKE_DIRECT_RANGE,              /* invoke-direct/range (0x76)  */
    DOP35_INVOKE_STATIC_RANGE,              /* invoke-static/range (0x77)  */
    DOP35_INVOKE_INTERFACE_RANGE,           /* invoke-interface/range (0x78)*/
    DOP35_UNUSED_79,                        /* unused-79 (0x79)            */
    DOP35_UNUSED_7A,                        /* unused-7a (0x7a)            */
    DOP35_NEG_INT,                          /* neg-int (0x7b)              */
    DOP35_NOT_INT,                          /* not-int (0x7c)              */
    DOP35_NEG_LONG,                         /* neg-long (0x7d)             */
    DOP35_NOT_LONG,                         /* not-long (0x7e)             */
    DOP35_NEG_FLOAT,                        /* neg-float (0x7f)            */
    DOP35_NEG_DOUBLE,                       /* neg-double (0x80)           */
    DOP35_INT_TO_LONG,                      /* int-to-long (0x81)          */
    DOP35_INT_TO_FLOAT,                     /* int-to-float (0x82)         */
    DOP35_INT_TO_DOUBLE,                    /* int-to-double (0x83)        */
    DOP35_LONG_TO_INT,                      /* long-to-int (0x84)          */
    DOP35_LONG_TO_FLOAT,                    /* long-to-float (0x85)        */
    DOP35_LONG_TO_DOUBLE,                   /* long-to-double (0x86)       */
    DOP35_FLOAT_TO_INT,                     /* float-to-int (0x87)         */
    DOP35_FLOAT_TO_LONG,                    /* float-to-long (0x88)        */
    DOP35_FLOAT_TO_DOUBLE,                  /* float-to-double (0x89)      */
    DOP35_DOUBLE_TO_INT,                    /* double-to-int (0x8a)        */
    DOP35_DOUBLE_TO_LONG,                   /* double-to-long (0x8b)       */
    DOP35_DOUBLE_TO_FLOAT,                  /* double-to-float (0x8c)      */
    DOP35_INT_TO_BYTE,                      /* int-to-byte (0x8d)          */
    DOP35_INT_TO_CHAR,                      /* int-to-char (0x8e)          */
    DOP35_INT_TO_SHORT,                     /* int-to-short (0x8f)         */
    DOP35_ADD_INT,                          /* add-int (0x90)              */
    DOP35_SUB_INT,                          /* sub-int (0x91)              */
    DOP35_MUL_INT,                          /* mul-int (0x92)              */
    DOP35_DIV_INT,                          /* div-int (0x93)              */
    DOP35_REM_INT,                          /* rem-int (0x94)              */
    DOP35_AND_INT,                          /* and-int (0x95)              */
    DOP35_OR_INT,                           /* or-int (0x96)               */
    DOP35_XOR_INT,                          /* xor-int (0x97)              */
    DOP35_SHL_INT,                          /* shl-int (0x98)              */
    DOP35_SHR_INT,                          /* shr-int (0x99)              */
    DOP35_USHR_INT,                         /* ushr-int (0x9a)             */
    DOP35_ADD_LONG,                         /* add-long (0x9b)             */
    DOP35_SUB_LONG,                         /* sub-long (0x9c)             */
    DOP35_MUL_LONG,                         /* mul-long (0x9d)             */
    DOP35_DIV_LONG,                         /* div-long (0x9e)             */
    DOP35_REM_LONG,                         /* rem-long (0x9f)             */
    DOP35_AND_LONG,                         /* and-long (0xa0)             */
    DOP35_OR_LONG,                          /* or-long (0xa1)              */
    DOP35_XOR_LONG,                         /* xor-long (0xa2)             */
    DOP35_SHL_LONG,                         /* shl-long (0xa3)             */
    DOP35_SHR_LONG,                         /* shr-long (0xa4)             */
    DOP35_USHR_LONG,                        /* ushr-long (0xa5)            */
    DOP35_ADD_FLOAT,                        /* add-float (0xa6)            */
    DOP35_SUB_FLOAT,                        /* sub-float (0xa7)            */
    DOP35_MUL_FLOAT,                        /* mul-float (0xa8)            */
    DOP35_DIV_FLOAT,                        /* div-float (0xa9)            */
    DOP35_REM_FLOAT,                        /* rem-float (0xaa)            */
    DOP35_ADD_DOUBLE,                       /* add-double (0xab)           */
    DOP35_SUB_DOUBLE,                       /* sub-double (0xac)           */
    DOP35_MUL_DOUBLE,                       /* mul-double (0xad)           */
    DOP35_DIV_DOUBLE,                       /* div-double (0xae)           */
    DOP35_REM_DOUBLE,                       /* rem-double (0xaf)           */
    DOP35_ADD_INT_2ADDR,                    /* add-int/2addr (0xb0)        */
    DOP35_SUB_INT_2ADDR,                    /* sub-int/2addr (0xb1)        */
    DOP35_MUL_INT_2ADDR,                    /* mul-int/2addr (0xb2)        */
    DOP35_DIV_INT_2ADDR,                    /* div-int/2addr (0xb3)        */
    DOP35_REM_INT_2ADDR,                    /* rem-int/2addr (0xb4)        */
    DOP35_AND_INT_2ADDR,                    /* and-int/2addr (0xb5)        */
    DOP35_OR_INT_2ADDR,                     /* or-int/2addr (0xb6)         */
    DOP35_XOR_INT_2ADDR,                    /* xor-int/2addr (0xb7)        */
    DOP35_SHL_INT_2ADDR,                    /* shl-int/2addr (0xb8)        */
    DOP35_SHR_INT_2ADDR,                    /* shr-int/2addr (0xb9)        */
    DOP35_USHR_INT_2ADDR,                   /* ushr-int/2addr (0xba)       */
    DOP35_ADD_LONG_2ADDR,                   /* add-long/2addr (0xbb)       */
    DOP35_SUB_LONG_2ADDR,                   /* sub-long/2addr (0xbc)       */
    DOP35_MUL_LONG_2ADDR,                   /* mul-long/2addr (0xbd)       */
    DOP35_DIV_LONG_2ADDR,                   /* div-long/2addr (0xbe)       */
    DOP35_REM_LONG_2ADDR,                   /* rem-long/2addr (0xbf)       */
    DOP35_AND_LONG_2ADDR,                   /* and-long/2addr (0xc0)       */
    DOP35_OR_LONG_2ADDR,                    /* or-long/2addr (0xc1)        */
    DOP35_XOR_LONG_2ADDR,                   /* xor-long/2addr (0xc2)       */
    DOP35_SHL_LONG_2ADDR,                   /* shl-long/2addr (0xc3)       */
    DOP35_SHR_LONG_2ADDR,                   /* shr-long/2addr (0xc4)       */
    DOP35_USHR_LONG_2ADDR,                  /* ushr-long/2addr (0xc5)      */
    DOP35_ADD_FLOAT_2ADDR,                  /* add-float/2addr (0xc6)      */
    DOP35_SUB_FLOAT_2ADDR,                  /* sub-float/2addr (0xc7)      */
    DOP35_MUL_FLOAT_2ADDR,                  /* mul-float/2addr (0xc8)      */
    DOP35_DIV_FLOAT_2ADDR,                  /* div-float/2addr (0xc9)      */
    DOP35_REM_FLOAT_2ADDR,                  /* rem-float/2addr (0xca)      */
    DOP35_ADD_DOUBLE_2ADDR,                 /* add-double/2addr (0xcb)     */
    DOP35_SUB_DOUBLE_2ADDR,                 /* sub-double/2addr (0xcc)     */
    DOP35_MUL_DOUBLE_2ADDR,                 /* mul-double/2addr (0xcd)     */
    DOP35_DIV_DOUBLE_2ADDR,                 /* div-double/2addr (0xce)     */
    DOP35_REM_DOUBLE_2ADDR,                 /* rem-double/2addr (0xcf)     */
    DOP35_ADD_INT_LIT16,                    /* add-int/lit16 (0xd0)        */
    DOP35_RSUB_INT,                         /* rsub-int (0xd1)             */
    DOP35_MUL_INT_LIT16,                    /* mul-int/lit16 (0xd2)        */
    DOP35_DIV_INT_LIT16,                    /* div-int/lit16 (0xd3)        */
    DOP35_REM_INT_LIT16,                    /* rem-int/lit16 (0xd4)        */
    DOP35_AND_INT_LIT16,                    /* and-int/lit16 (0xd5)        */
    DOP35_OR_INT_LIT16,                     /* or-int/lit16 (0xd6)         */
    DOP35_XOR_INT_LIT16,                    /* xor-int/lit16 (0xd7)        */
    DOP35_ADD_INT_LIT8,                     /* add-int/lit8 (0xd8)         */
    DOP35_RSUB_INT_LIT8,                    /* rsub-int/lit8 (0xd9)        */
    DOP35_MUL_INT_LIT8,                     /* mul-int/lit8 (0xda)         */
    DOP35_DIV_INT_LIT8,                     /* div-int/lit8 (0xdb)         */
    DOP35_REM_INT_LIT8,                     /* rem-int/lit8 (0xdc)         */
    DOP35_AND_INT_LIT8,                     /* and-int/lit8 (0xdd)         */
    DOP35_OR_INT_LIT8,                      /* or-int/lit8 (0xde)          */
    DOP35_XOR_INT_LIT8,                     /* xor-int/lit8 (0xdf)         */
    DOP35_SHL_INT_LIT8,                     /* shl-int/lit8 (0xe0)         */
    DOP35_SHR_INT_LIT8,                     /* shr-int/lit8 (0xe1)         */
    DOP35_USHR_INT_LIT8,                    /* ushr-int/lit8 (0xe2)        */
    DOP35_UNUSED_E3,                        /* unused-e3 (0xe3)            */
    DOP35_UNUSED_E4,                        /* unused-e4 (0xe4)            */
    DOP35_UNUSED_E5,                        /* unused-e5 (0xe5)            */
    DOP35_UNUSED_E6,                        /* unused-e6 (0xe6)            */
    DOP35_UNUSED_E7,                        /* unused-e7 (0xe7)            */
    DOP35_UNUSED_E8,                        /* unused-e8 (0xe8)            */
    DOP35_UNUSED_E9,                        /* unused-e9 (0xe9)            */
    DOP35_UNUSED_EA,                        /* unused-ea (0xea)            */
    DOP35_UNUSED_EB,                        /* unused-eb (0xeb)            */
    DOP35_UNUSED_EC,                        /* unused-ec (0xec)            */
    DOP35_UNUSED_ED,                        /* unused-ed (0xed)            */
    DOP35_UNUSED_EE,                        /* unused-ee (0xee)            */
    DOP35_UNUSED_EF,                        /* unused-ef (0xef)            */
    DOP35_UNUSED_F0,                        /* unused-f0 (0xf0)            */
    DOP35_UNUSED_F1,                        /* unused-f1 (0xf1)            */
    DOP35_UNUSED_F2,                        /* unused-f2 (0xf2)            */
    DOP35_UNUSED_F3,                        /* unused-f3 (0xf3)            */
    DOP35_UNUSED_F4,                        /* unused-f4 (0xf4)            */
    DOP35_UNUSED_F5,                        /* unused-f5 (0xf5)            */
    DOP35_UNUSED_F6,                        /* unused-f6 (0xf6)            */
    DOP35_UNUSED_F7,                        /* unused-f7 (0xf7)            */
    DOP35_UNUSED_F8,                        /* unused-f8 (0xf8)            */
    DOP35_UNUSED_F9,                        /* unused-f9 (0xf9)            */
    DOP35_UNUSED_FA,                        /* unused-fa (0xfa)            */
    DOP35_UNUSED_FB,                        /* unused-fb (0xfb)            */
    DOP35_UNUSED_FC,                        /* unused-fc (0xfc)            */
    DOP35_UNUSED_FD,                        /* unused-fd (0xfd)            */
    DOP35_UNUSED_FE,                        /* unused-fe (0xfe)            */
    DOP35_UNUSED_FF,                        /* unused-ff (0xff)            */

    DOP35_COUNT

} Dalvik35Opcodes;



#endif  /* _PLUGINS_DALVIK_V35_OPCODES_IDENTIFIERS_H */
