
/* Chrysalide - Outil d'analyse de fichiers binaires
 * keywords.h - définition des mots clefs des instructions Dalvik v35
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_DALVIK_V35_OPCODES_KEYWORDS_H
#define _PLUGINS_DALVIK_V35_OPCODES_KEYWORDS_H


#include "identifiers.h"



/* Enumération de tous les mots clefs */
static char *_dalvik35_keywords[DOP35_COUNT] = {

    [DOP35_NOP] = "nop",
    [DOP35_MOVE] = "move",
    [DOP35_MOVE_FROM16] = "move/from16",
    [DOP35_MOVE_16] = "move/16",
    [DOP35_MOVE_WIDE] = "move-wide",
    [DOP35_MOVE_WIDE_FROM16] = "move-wide/from16",
    [DOP35_MOVE_WIDE_16] = "move-wide/16",
    [DOP35_MOVE_OBJECT] = "move-object",
    [DOP35_MOVE_OBJECT_FROM16] = "move-object/from16",
    [DOP35_MOVE_OBJECT_16] = "move-object/16",
    [DOP35_MOVE_RESULT] = "move-result",
    [DOP35_MOVE_RESULT_WIDE] = "move-result-wide",
    [DOP35_MOVE_RESULT_OBJECT] = "move-result-object",
    [DOP35_MOVE_EXCEPTION] = "move-exception",
    [DOP35_RETURN_VOID] = "return-void",
    [DOP35_RETURN] = "return",
    [DOP35_RETURN_WIDE] = "return-wide",
    [DOP35_RETURN_OBJECT] = "return-object",
    [DOP35_CONST_4] = "const/4",
    [DOP35_CONST_16] = "const/16",
    [DOP35_CONST] = "const",
    [DOP35_CONST_HIGH16] = "const/high16",
    [DOP35_CONST_WIDE_16] = "const-wide/16",
    [DOP35_CONST_WIDE_32] = "const-wide/32",
    [DOP35_CONST_WIDE] = "const-wide",
    [DOP35_CONST_WIDE_HIGH16] = "const-wide/high16",
    [DOP35_CONST_STRING] = "const-string",
    [DOP35_CONST_STRING_JUMBO] = "const-string/jumbo",
    [DOP35_CONST_CLASS] = "const-class",
    [DOP35_MONITOR_ENTER] = "monitor-enter",
    [DOP35_MONITOR_EXIT] = "monitor-exit",
    [DOP35_CHECK_CAST] = "check-cast",
    [DOP35_INSTANCE_OF] = "instance-of",
    [DOP35_ARRAY_LENGTH] = "array-length",
    [DOP35_NEW_INSTANCE] = "new-instance",
    [DOP35_NEW_ARRAY] = "new-array",
    [DOP35_FILLED_NEW_ARRAY] = "filled-new-array",
    [DOP35_FILLED_NEW_ARRAY_RANGE] = "filled-new-array/range",
    [DOP35_FILL_ARRAY_DATA] = "fill-array-data",
    [DOP35_THROW] = "throw",
    [DOP35_GOTO] = "goto",
    [DOP35_GOTO_16] = "goto/16",
    [DOP35_GOTO_32] = "goto/32",
    [DOP35_PACKED_SWITCH] = "packed-switch",
    [DOP35_SPARSE_SWITCH] = "sparse-switch",
    [DOP35_CMPL_FLOAT] = "cmpl-float",
    [DOP35_CMPG_FLOAT] = "cmpg-float",
    [DOP35_CMPL_DOUBLE] = "cmpl-double",
    [DOP35_CMPG_DOUBLE] = "cmpg-double",
    [DOP35_CMP_LONG] = "cmp-long",
    [DOP35_IF_EQ] = "if-eq",
    [DOP35_IF_NE] = "if-ne",
    [DOP35_IF_LT] = "if-lt",
    [DOP35_IF_GE] = "if-ge",
    [DOP35_IF_GT] = "if-gt",
    [DOP35_IF_LE] = "if-le",
    [DOP35_IF_EQZ] = "if-eqz",
    [DOP35_IF_NEZ] = "if-nez",
    [DOP35_IF_LTZ] = "if-ltz",
    [DOP35_IF_GEZ] = "if-gez",
    [DOP35_IF_GTZ] = "if-gtz",
    [DOP35_IF_LEZ] = "if-lez",
    [DOP35_AGET] = "aget",
    [DOP35_AGET_WIDE] = "aget-wide",
    [DOP35_AGET_OBJECT] = "aget-object",
    [DOP35_AGET_BOOLEAN] = "aget-boolean",
    [DOP35_AGET_BYTE] = "aget-byte",
    [DOP35_AGET_CHAR] = "aget-char",
    [DOP35_AGET_SHORT] = "aget-short",
    [DOP35_APUT] = "aput",
    [DOP35_APUT_WIDE] = "aput-wide",
    [DOP35_APUT_OBJECT] = "aput-object",
    [DOP35_APUT_BOOLEAN] = "aput-boolean",
    [DOP35_APUT_BYTE] = "aput-byte",
    [DOP35_APUT_CHAR] = "aput-char",
    [DOP35_APUT_SHORT] = "aput-short",
    [DOP35_IGET] = "iget",
    [DOP35_IGET_WIDE] = "iget-wide",
    [DOP35_IGET_OBJECT] = "iget-object",
    [DOP35_IGET_BOOLEAN] = "iget-boolean",
    [DOP35_IGET_BYTE] = "iget-byte",
    [DOP35_IGET_CHAR] = "iget-char",
    [DOP35_IGET_SHORT] = "iget-short",
    [DOP35_IPUT] = "iput",
    [DOP35_IPUT_WIDE] = "iput-wide",
    [DOP35_IPUT_OBJECT] = "iput-object",
    [DOP35_IPUT_BOOLEAN] = "iput-boolean",
    [DOP35_IPUT_BYTE] = "iput-byte",
    [DOP35_IPUT_CHAR] = "iput-char",
    [DOP35_IPUT_SHORT] = "iput-short",
    [DOP35_SGET] = "sget",
    [DOP35_SGET_WIDE] = "sget-wide",
    [DOP35_SGET_OBJECT] = "sget-object",
    [DOP35_SGET_BOOLEAN] = "sget-boolean",
    [DOP35_SGET_BYTE] = "sget-byte",
    [DOP35_SGET_CHAR] = "sget-char",
    [DOP35_SGET_SHORT] = "sget-short",
    [DOP35_SPUT] = "sput",
    [DOP35_SPUT_WIDE] = "sput-wide",
    [DOP35_SPUT_OBJECT] = "sput-object",
    [DOP35_SPUT_BOOLEAN] = "sput-boolean",
    [DOP35_SPUT_BYTE] = "sput-byte",
    [DOP35_SPUT_CHAR] = "sput-char",
    [DOP35_SPUT_SHORT] = "sput-short",
    [DOP35_INVOKE_VIRTUAL] = "invoke-virtual",
    [DOP35_INVOKE_SUPER] = "invoke-super",
    [DOP35_INVOKE_DIRECT] = "invoke-direct",
    [DOP35_INVOKE_STATIC] = "invoke-static",
    [DOP35_INVOKE_INTERFACE] = "invoke-interface",
    [DOP35_INVOKE_VIRTUAL_RANGE] = "invoke-virtual/range",
    [DOP35_INVOKE_SUPER_RANGE] = "invoke-super/range",
    [DOP35_INVOKE_DIRECT_RANGE] = "invoke-direct/range",
    [DOP35_INVOKE_STATIC_RANGE] = "invoke-static/range",
    [DOP35_INVOKE_INTERFACE_RANGE] = "invoke-interface/range",
    [DOP35_NEG_INT] = "neg-int",
    [DOP35_NOT_INT] = "not-int",
    [DOP35_NEG_LONG] = "neg-long",
    [DOP35_NOT_LONG] = "not-long",
    [DOP35_NEG_FLOAT] = "neg-float",
    [DOP35_NEG_DOUBLE] = "neg-double",
    [DOP35_INT_TO_LONG] = "int-to-long",
    [DOP35_INT_TO_FLOAT] = "int-to-float",
    [DOP35_INT_TO_DOUBLE] = "int-to-double",
    [DOP35_LONG_TO_INT] = "long-to-int",
    [DOP35_LONG_TO_FLOAT] = "long-to-float",
    [DOP35_LONG_TO_DOUBLE] = "long-to-double",
    [DOP35_FLOAT_TO_INT] = "float-to-int",
    [DOP35_FLOAT_TO_LONG] = "float-to-long",
    [DOP35_FLOAT_TO_DOUBLE] = "float-to-double",
    [DOP35_DOUBLE_TO_INT] = "double-to-int",
    [DOP35_DOUBLE_TO_LONG] = "double-to-long",
    [DOP35_DOUBLE_TO_FLOAT] = "double-to-float",
    [DOP35_INT_TO_BYTE] = "int-to-byte",
    [DOP35_INT_TO_CHAR] = "int-to-char",
    [DOP35_INT_TO_SHORT] = "int-to-short",
    [DOP35_ADD_INT] = "add-int",
    [DOP35_SUB_INT] = "sub-int",
    [DOP35_MUL_INT] = "mul-int",
    [DOP35_DIV_INT] = "div-int",
    [DOP35_REM_INT] = "rem-int",
    [DOP35_AND_INT] = "and-int",
    [DOP35_OR_INT] = "or-int",
    [DOP35_XOR_INT] = "xor-int",
    [DOP35_SHL_INT] = "shl-int",
    [DOP35_SHR_INT] = "shr-int",
    [DOP35_USHR_INT] = "ushr-int",
    [DOP35_ADD_LONG] = "add-long",
    [DOP35_SUB_LONG] = "sub-long",
    [DOP35_MUL_LONG] = "mul-long",
    [DOP35_DIV_LONG] = "div-long",
    [DOP35_REM_LONG] = "rem-long",
    [DOP35_AND_LONG] = "and-long",
    [DOP35_OR_LONG] = "or-long",
    [DOP35_XOR_LONG] = "xor-long",
    [DOP35_SHL_LONG] = "shl-long",
    [DOP35_SHR_LONG] = "shr-long",
    [DOP35_USHR_LONG] = "ushr-long",
    [DOP35_ADD_FLOAT] = "add-float",
    [DOP35_SUB_FLOAT] = "sub-float",
    [DOP35_MUL_FLOAT] = "mul-float",
    [DOP35_DIV_FLOAT] = "div-float",
    [DOP35_REM_FLOAT] = "rem-float",
    [DOP35_ADD_DOUBLE] = "add-double",
    [DOP35_SUB_DOUBLE] = "sub-double",
    [DOP35_MUL_DOUBLE] = "mul-double",
    [DOP35_DIV_DOUBLE] = "div-double",
    [DOP35_REM_DOUBLE] = "rem-double",
    [DOP35_ADD_INT_2ADDR] = "add-int/2addr",
    [DOP35_SUB_INT_2ADDR] = "sub-int/2addr",
    [DOP35_MUL_INT_2ADDR] = "mul-int/2addr",
    [DOP35_DIV_INT_2ADDR] = "div-int/2addr",
    [DOP35_REM_INT_2ADDR] = "rem-int/2addr",
    [DOP35_AND_INT_2ADDR] = "and-int/2addr",
    [DOP35_OR_INT_2ADDR] = "or-int/2addr",
    [DOP35_XOR_INT_2ADDR] = "xor-int/2addr",
    [DOP35_SHL_INT_2ADDR] = "shl-int/2addr",
    [DOP35_SHR_INT_2ADDR] = "shr-int/2addr",
    [DOP35_USHR_INT_2ADDR] = "ushr-int/2addr",
    [DOP35_ADD_LONG_2ADDR] = "add-long/2addr",
    [DOP35_SUB_LONG_2ADDR] = "sub-long/2addr",
    [DOP35_MUL_LONG_2ADDR] = "mul-long/2addr",
    [DOP35_DIV_LONG_2ADDR] = "div-long/2addr",
    [DOP35_REM_LONG_2ADDR] = "rem-long/2addr",
    [DOP35_AND_LONG_2ADDR] = "and-long/2addr",
    [DOP35_OR_LONG_2ADDR] = "or-long/2addr",
    [DOP35_XOR_LONG_2ADDR] = "xor-long/2addr",
    [DOP35_SHL_LONG_2ADDR] = "shl-long/2addr",
    [DOP35_SHR_LONG_2ADDR] = "shr-long/2addr",
    [DOP35_USHR_LONG_2ADDR] = "ushr-long/2addr",
    [DOP35_ADD_FLOAT_2ADDR] = "add-float/2addr",
    [DOP35_SUB_FLOAT_2ADDR] = "sub-float/2addr",
    [DOP35_MUL_FLOAT_2ADDR] = "mul-float/2addr",
    [DOP35_DIV_FLOAT_2ADDR] = "div-float/2addr",
    [DOP35_REM_FLOAT_2ADDR] = "rem-float/2addr",
    [DOP35_ADD_DOUBLE_2ADDR] = "add-double/2addr",
    [DOP35_SUB_DOUBLE_2ADDR] = "sub-double/2addr",
    [DOP35_MUL_DOUBLE_2ADDR] = "mul-double/2addr",
    [DOP35_DIV_DOUBLE_2ADDR] = "div-double/2addr",
    [DOP35_REM_DOUBLE_2ADDR] = "rem-double/2addr",
    [DOP35_ADD_INT_LIT16] = "add-int/lit16",
    [DOP35_RSUB_INT] = "rsub-int",
    [DOP35_MUL_INT_LIT16] = "mul-int/lit16",
    [DOP35_DIV_INT_LIT16] = "div-int/lit16",
    [DOP35_REM_INT_LIT16] = "rem-int/lit16",
    [DOP35_AND_INT_LIT16] = "and-int/lit16",
    [DOP35_OR_INT_LIT16] = "or-int/lit16",
    [DOP35_XOR_INT_LIT16] = "xor-int/lit16",
    [DOP35_ADD_INT_LIT8] = "add-int/lit8",
    [DOP35_RSUB_INT_LIT8] = "rsub-int/lit8",
    [DOP35_MUL_INT_LIT8] = "mul-int/lit8",
    [DOP35_DIV_INT_LIT8] = "div-int/lit8",
    [DOP35_REM_INT_LIT8] = "rem-int/lit8",
    [DOP35_AND_INT_LIT8] = "and-int/lit8",
    [DOP35_OR_INT_LIT8] = "or-int/lit8",
    [DOP35_XOR_INT_LIT8] = "xor-int/lit8",
    [DOP35_SHL_INT_LIT8] = "shl-int/lit8",
    [DOP35_SHR_INT_LIT8] = "shr-int/lit8",
    [DOP35_USHR_INT_LIT8] = "ushr-int/lit8",

};



#endif  /* _PLUGINS_DALVIK_V35_OPCODES_KEYWORDS_H */
