
/* Chrysalide - Outil d'analyse de fichiers binaires
 * opcodes.h - prototypes pour la traduction d'instructions Dalvik v35
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_DALVIK_V35_OPCODES_OPCODES_H
#define _PLUGINS_DALVIK_V35_OPCODES_OPCODES_H


#include <stdint.h> 
 
#include <analysis/content.h> 
#include <arch/context.h> 
#include <format/executable.h> 
 
#include "../processor.h"



/* Décode une instruction de type 'nop'. */
GArchInstruction *dalvik35_read_instr_nop(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move'. */
GArchInstruction *dalvik35_read_instr_move(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move'. */
GArchInstruction *dalvik35_read_instr_move_from16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move'. */
GArchInstruction *dalvik35_read_instr_move_16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-wide'. */
GArchInstruction *dalvik35_read_instr_move_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-wide'. */
GArchInstruction *dalvik35_read_instr_move_wide_from16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-wide'. */
GArchInstruction *dalvik35_read_instr_move_wide_16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-object'. */
GArchInstruction *dalvik35_read_instr_move_object(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-object'. */
GArchInstruction *dalvik35_read_instr_move_object_from16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-object'. */
GArchInstruction *dalvik35_read_instr_move_object_16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-result'. */
GArchInstruction *dalvik35_read_instr_move_result(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-result-wide'. */
GArchInstruction *dalvik35_read_instr_move_result_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-result-object'. */
GArchInstruction *dalvik35_read_instr_move_result_object(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'move-exception'. */
GArchInstruction *dalvik35_read_instr_move_exception(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'return-void'. */
GArchInstruction *dalvik35_read_instr_return_void(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'return'. */
GArchInstruction *dalvik35_read_instr_return(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'return-wide'. */
GArchInstruction *dalvik35_read_instr_return_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'return-object'. */
GArchInstruction *dalvik35_read_instr_return_object(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const'. */
GArchInstruction *dalvik35_read_instr_const_4(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const'. */
GArchInstruction *dalvik35_read_instr_const_16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const'. */
GArchInstruction *dalvik35_read_instr_const(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const'. */
GArchInstruction *dalvik35_read_instr_const_high16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const-wide'. */
GArchInstruction *dalvik35_read_instr_const_wide_16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const-wide'. */
GArchInstruction *dalvik35_read_instr_const_wide_32(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const-wide'. */
GArchInstruction *dalvik35_read_instr_const_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const-wide'. */
GArchInstruction *dalvik35_read_instr_const_wide_high16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const-string'. */
GArchInstruction *dalvik35_read_instr_const_string(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const-string'. */
GArchInstruction *dalvik35_read_instr_const_string_jumbo(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'const-class'. */
GArchInstruction *dalvik35_read_instr_const_class(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'monitor-enter'. */
GArchInstruction *dalvik35_read_instr_monitor_enter(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'monitor-exit'. */
GArchInstruction *dalvik35_read_instr_monitor_exit(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'check-cast'. */
GArchInstruction *dalvik35_read_instr_check_cast(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'instance-of'. */
GArchInstruction *dalvik35_read_instr_instance_of(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'array-length'. */
GArchInstruction *dalvik35_read_instr_array_length(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'new-instance'. */
GArchInstruction *dalvik35_read_instr_new_instance(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'new-array'. */
GArchInstruction *dalvik35_read_instr_new_array(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'filled-new-array'. */
GArchInstruction *dalvik35_read_instr_filled_new_array(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'filled-new-array'. */
GArchInstruction *dalvik35_read_instr_filled_new_array_range(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'fill-array-data'. */
GArchInstruction *dalvik35_read_instr_fill_array_data(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'throw'. */
GArchInstruction *dalvik35_read_instr_throw(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'goto'. */
GArchInstruction *dalvik35_read_instr_goto(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'goto'. */
GArchInstruction *dalvik35_read_instr_goto_16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'goto'. */
GArchInstruction *dalvik35_read_instr_goto_32(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'packed-switch'. */
GArchInstruction *dalvik35_read_instr_packed_switch(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sparse-switch'. */
GArchInstruction *dalvik35_read_instr_sparse_switch(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'cmpl-float'. */
GArchInstruction *dalvik35_read_instr_cmpl_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'cmpg-float'. */
GArchInstruction *dalvik35_read_instr_cmpg_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'cmpl-double'. */
GArchInstruction *dalvik35_read_instr_cmpl_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'cmpg-double'. */
GArchInstruction *dalvik35_read_instr_cmpg_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'cmp-long'. */
GArchInstruction *dalvik35_read_instr_cmp_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-eq'. */
GArchInstruction *dalvik35_read_instr_if_eq(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-ne'. */
GArchInstruction *dalvik35_read_instr_if_ne(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-lt'. */
GArchInstruction *dalvik35_read_instr_if_lt(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-ge'. */
GArchInstruction *dalvik35_read_instr_if_ge(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-gt'. */
GArchInstruction *dalvik35_read_instr_if_gt(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-le'. */
GArchInstruction *dalvik35_read_instr_if_le(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-eqz'. */
GArchInstruction *dalvik35_read_instr_if_eqz(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-nez'. */
GArchInstruction *dalvik35_read_instr_if_nez(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-ltz'. */
GArchInstruction *dalvik35_read_instr_if_ltz(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-gez'. */
GArchInstruction *dalvik35_read_instr_if_gez(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-gtz'. */
GArchInstruction *dalvik35_read_instr_if_gtz(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'if-lez'. */
GArchInstruction *dalvik35_read_instr_if_lez(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-3e'. */
GArchInstruction *dalvik35_read_instr_unused_3e(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-3f'. */
GArchInstruction *dalvik35_read_instr_unused_3f(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-40'. */
GArchInstruction *dalvik35_read_instr_unused_40(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-41'. */
GArchInstruction *dalvik35_read_instr_unused_41(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-42'. */
GArchInstruction *dalvik35_read_instr_unused_42(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-43'. */
GArchInstruction *dalvik35_read_instr_unused_43(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aget'. */
GArchInstruction *dalvik35_read_instr_aget(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aget-wide'. */
GArchInstruction *dalvik35_read_instr_aget_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aget-object'. */
GArchInstruction *dalvik35_read_instr_aget_object(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aget-boolean'. */
GArchInstruction *dalvik35_read_instr_aget_boolean(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aget-byte'. */
GArchInstruction *dalvik35_read_instr_aget_byte(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aget-char'. */
GArchInstruction *dalvik35_read_instr_aget_char(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aget-short'. */
GArchInstruction *dalvik35_read_instr_aget_short(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aput'. */
GArchInstruction *dalvik35_read_instr_aput(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aput-wide'. */
GArchInstruction *dalvik35_read_instr_aput_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aput-object'. */
GArchInstruction *dalvik35_read_instr_aput_object(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aput-boolean'. */
GArchInstruction *dalvik35_read_instr_aput_boolean(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aput-byte'. */
GArchInstruction *dalvik35_read_instr_aput_byte(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aput-char'. */
GArchInstruction *dalvik35_read_instr_aput_char(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'aput-short'. */
GArchInstruction *dalvik35_read_instr_aput_short(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iget'. */
GArchInstruction *dalvik35_read_instr_iget(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iget-wide'. */
GArchInstruction *dalvik35_read_instr_iget_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iget-object'. */
GArchInstruction *dalvik35_read_instr_iget_object(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iget-boolean'. */
GArchInstruction *dalvik35_read_instr_iget_boolean(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iget-byte'. */
GArchInstruction *dalvik35_read_instr_iget_byte(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iget-char'. */
GArchInstruction *dalvik35_read_instr_iget_char(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iget-short'. */
GArchInstruction *dalvik35_read_instr_iget_short(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iput'. */
GArchInstruction *dalvik35_read_instr_iput(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iput-wide'. */
GArchInstruction *dalvik35_read_instr_iput_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iput-object'. */
GArchInstruction *dalvik35_read_instr_iput_object(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iput-boolean'. */
GArchInstruction *dalvik35_read_instr_iput_boolean(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iput-byte'. */
GArchInstruction *dalvik35_read_instr_iput_byte(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iput-char'. */
GArchInstruction *dalvik35_read_instr_iput_char(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'iput-short'. */
GArchInstruction *dalvik35_read_instr_iput_short(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sget'. */
GArchInstruction *dalvik35_read_instr_sget(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sget-wide'. */
GArchInstruction *dalvik35_read_instr_sget_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sget-object'. */
GArchInstruction *dalvik35_read_instr_sget_object(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sget-boolean'. */
GArchInstruction *dalvik35_read_instr_sget_boolean(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sget-byte'. */
GArchInstruction *dalvik35_read_instr_sget_byte(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sget-char'. */
GArchInstruction *dalvik35_read_instr_sget_char(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sget-short'. */
GArchInstruction *dalvik35_read_instr_sget_short(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sput'. */
GArchInstruction *dalvik35_read_instr_sput(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sput-wide'. */
GArchInstruction *dalvik35_read_instr_sput_wide(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sput-object'. */
GArchInstruction *dalvik35_read_instr_sput_object(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sput-boolean'. */
GArchInstruction *dalvik35_read_instr_sput_boolean(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sput-byte'. */
GArchInstruction *dalvik35_read_instr_sput_byte(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sput-char'. */
GArchInstruction *dalvik35_read_instr_sput_char(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sput-short'. */
GArchInstruction *dalvik35_read_instr_sput_short(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-virtual'. */
GArchInstruction *dalvik35_read_instr_invoke_virtual(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-super'. */
GArchInstruction *dalvik35_read_instr_invoke_super(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-direct'. */
GArchInstruction *dalvik35_read_instr_invoke_direct(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-static'. */
GArchInstruction *dalvik35_read_instr_invoke_static(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-interface'. */
GArchInstruction *dalvik35_read_instr_invoke_interface(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-73'. */
GArchInstruction *dalvik35_read_instr_unused_73(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-virtual'. */
GArchInstruction *dalvik35_read_instr_invoke_virtual_range(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-super'. */
GArchInstruction *dalvik35_read_instr_invoke_super_range(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-direct'. */
GArchInstruction *dalvik35_read_instr_invoke_direct_range(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-static'. */
GArchInstruction *dalvik35_read_instr_invoke_static_range(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'invoke-interface'. */
GArchInstruction *dalvik35_read_instr_invoke_interface_range(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-79'. */
GArchInstruction *dalvik35_read_instr_unused_79(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-7a'. */
GArchInstruction *dalvik35_read_instr_unused_7a(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'neg-int'. */
GArchInstruction *dalvik35_read_instr_neg_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'not-int'. */
GArchInstruction *dalvik35_read_instr_not_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'neg-long'. */
GArchInstruction *dalvik35_read_instr_neg_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'not-long'. */
GArchInstruction *dalvik35_read_instr_not_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'neg-float'. */
GArchInstruction *dalvik35_read_instr_neg_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'neg-double'. */
GArchInstruction *dalvik35_read_instr_neg_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'int-to-long'. */
GArchInstruction *dalvik35_read_instr_int_to_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'int-to-float'. */
GArchInstruction *dalvik35_read_instr_int_to_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'int-to-double'. */
GArchInstruction *dalvik35_read_instr_int_to_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'long-to-int'. */
GArchInstruction *dalvik35_read_instr_long_to_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'long-to-float'. */
GArchInstruction *dalvik35_read_instr_long_to_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'long-to-double'. */
GArchInstruction *dalvik35_read_instr_long_to_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'float-to-int'. */
GArchInstruction *dalvik35_read_instr_float_to_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'float-to-long'. */
GArchInstruction *dalvik35_read_instr_float_to_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'float-to-double'. */
GArchInstruction *dalvik35_read_instr_float_to_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'double-to-int'. */
GArchInstruction *dalvik35_read_instr_double_to_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'double-to-long'. */
GArchInstruction *dalvik35_read_instr_double_to_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'double-to-float'. */
GArchInstruction *dalvik35_read_instr_double_to_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'int-to-byte'. */
GArchInstruction *dalvik35_read_instr_int_to_byte(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'int-to-char'. */
GArchInstruction *dalvik35_read_instr_int_to_char(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'int-to-short'. */
GArchInstruction *dalvik35_read_instr_int_to_short(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-int'. */
GArchInstruction *dalvik35_read_instr_add_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sub-int'. */
GArchInstruction *dalvik35_read_instr_sub_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-int'. */
GArchInstruction *dalvik35_read_instr_mul_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-int'. */
GArchInstruction *dalvik35_read_instr_div_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-int'. */
GArchInstruction *dalvik35_read_instr_rem_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'and-int'. */
GArchInstruction *dalvik35_read_instr_and_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'or-int'. */
GArchInstruction *dalvik35_read_instr_or_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'xor-int'. */
GArchInstruction *dalvik35_read_instr_xor_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shl-int'. */
GArchInstruction *dalvik35_read_instr_shl_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shr-int'. */
GArchInstruction *dalvik35_read_instr_shr_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'ushr-int'. */
GArchInstruction *dalvik35_read_instr_ushr_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-long'. */
GArchInstruction *dalvik35_read_instr_add_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sub-long'. */
GArchInstruction *dalvik35_read_instr_sub_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-long'. */
GArchInstruction *dalvik35_read_instr_mul_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-long'. */
GArchInstruction *dalvik35_read_instr_div_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-long'. */
GArchInstruction *dalvik35_read_instr_rem_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'and-long'. */
GArchInstruction *dalvik35_read_instr_and_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'or-long'. */
GArchInstruction *dalvik35_read_instr_or_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'xor-long'. */
GArchInstruction *dalvik35_read_instr_xor_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shl-long'. */
GArchInstruction *dalvik35_read_instr_shl_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shr-long'. */
GArchInstruction *dalvik35_read_instr_shr_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'ushr-long'. */
GArchInstruction *dalvik35_read_instr_ushr_long(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-float'. */
GArchInstruction *dalvik35_read_instr_add_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sub-float'. */
GArchInstruction *dalvik35_read_instr_sub_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-float'. */
GArchInstruction *dalvik35_read_instr_mul_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-float'. */
GArchInstruction *dalvik35_read_instr_div_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-float'. */
GArchInstruction *dalvik35_read_instr_rem_float(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-double'. */
GArchInstruction *dalvik35_read_instr_add_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sub-double'. */
GArchInstruction *dalvik35_read_instr_sub_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-double'. */
GArchInstruction *dalvik35_read_instr_mul_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-double'. */
GArchInstruction *dalvik35_read_instr_div_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-double'. */
GArchInstruction *dalvik35_read_instr_rem_double(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-int'. */
GArchInstruction *dalvik35_read_instr_add_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sub-int'. */
GArchInstruction *dalvik35_read_instr_sub_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-int'. */
GArchInstruction *dalvik35_read_instr_mul_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-int'. */
GArchInstruction *dalvik35_read_instr_div_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-int'. */
GArchInstruction *dalvik35_read_instr_rem_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'and-int'. */
GArchInstruction *dalvik35_read_instr_and_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'or-int'. */
GArchInstruction *dalvik35_read_instr_or_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'xor-int'. */
GArchInstruction *dalvik35_read_instr_xor_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shl-int'. */
GArchInstruction *dalvik35_read_instr_shl_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shr-int'. */
GArchInstruction *dalvik35_read_instr_shr_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'ushr-int'. */
GArchInstruction *dalvik35_read_instr_ushr_int_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-long'. */
GArchInstruction *dalvik35_read_instr_add_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sub-long'. */
GArchInstruction *dalvik35_read_instr_sub_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-long'. */
GArchInstruction *dalvik35_read_instr_mul_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-long'. */
GArchInstruction *dalvik35_read_instr_div_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-long'. */
GArchInstruction *dalvik35_read_instr_rem_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'and-long'. */
GArchInstruction *dalvik35_read_instr_and_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'or-long'. */
GArchInstruction *dalvik35_read_instr_or_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'xor-long'. */
GArchInstruction *dalvik35_read_instr_xor_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shl-long'. */
GArchInstruction *dalvik35_read_instr_shl_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shr-long'. */
GArchInstruction *dalvik35_read_instr_shr_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'ushr-long'. */
GArchInstruction *dalvik35_read_instr_ushr_long_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-float'. */
GArchInstruction *dalvik35_read_instr_add_float_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sub-float'. */
GArchInstruction *dalvik35_read_instr_sub_float_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-float'. */
GArchInstruction *dalvik35_read_instr_mul_float_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-float'. */
GArchInstruction *dalvik35_read_instr_div_float_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-float'. */
GArchInstruction *dalvik35_read_instr_rem_float_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-double'. */
GArchInstruction *dalvik35_read_instr_add_double_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'sub-double'. */
GArchInstruction *dalvik35_read_instr_sub_double_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-double'. */
GArchInstruction *dalvik35_read_instr_mul_double_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-double'. */
GArchInstruction *dalvik35_read_instr_div_double_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-double'. */
GArchInstruction *dalvik35_read_instr_rem_double_2addr(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-int'. */
GArchInstruction *dalvik35_read_instr_add_int_lit16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rsub-int'. */
GArchInstruction *dalvik35_read_instr_rsub_int(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-int'. */
GArchInstruction *dalvik35_read_instr_mul_int_lit16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-int'. */
GArchInstruction *dalvik35_read_instr_div_int_lit16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-int'. */
GArchInstruction *dalvik35_read_instr_rem_int_lit16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'and-int'. */
GArchInstruction *dalvik35_read_instr_and_int_lit16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'or-int'. */
GArchInstruction *dalvik35_read_instr_or_int_lit16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'xor-int'. */
GArchInstruction *dalvik35_read_instr_xor_int_lit16(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'add-int'. */
GArchInstruction *dalvik35_read_instr_add_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rsub-int'. */
GArchInstruction *dalvik35_read_instr_rsub_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'mul-int'. */
GArchInstruction *dalvik35_read_instr_mul_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'div-int'. */
GArchInstruction *dalvik35_read_instr_div_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'rem-int'. */
GArchInstruction *dalvik35_read_instr_rem_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'and-int'. */
GArchInstruction *dalvik35_read_instr_and_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'or-int'. */
GArchInstruction *dalvik35_read_instr_or_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'xor-int'. */
GArchInstruction *dalvik35_read_instr_xor_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shl-int'. */
GArchInstruction *dalvik35_read_instr_shl_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'shr-int'. */
GArchInstruction *dalvik35_read_instr_shr_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'ushr-int'. */
GArchInstruction *dalvik35_read_instr_ushr_int_lit8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-e3'. */
GArchInstruction *dalvik35_read_instr_unused_e3(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-e4'. */
GArchInstruction *dalvik35_read_instr_unused_e4(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-e5'. */
GArchInstruction *dalvik35_read_instr_unused_e5(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-e6'. */
GArchInstruction *dalvik35_read_instr_unused_e6(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-e7'. */
GArchInstruction *dalvik35_read_instr_unused_e7(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-e8'. */
GArchInstruction *dalvik35_read_instr_unused_e8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-e9'. */
GArchInstruction *dalvik35_read_instr_unused_e9(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-ea'. */
GArchInstruction *dalvik35_read_instr_unused_ea(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-eb'. */
GArchInstruction *dalvik35_read_instr_unused_eb(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-ec'. */
GArchInstruction *dalvik35_read_instr_unused_ec(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-ed'. */
GArchInstruction *dalvik35_read_instr_unused_ed(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-ee'. */
GArchInstruction *dalvik35_read_instr_unused_ee(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-ef'. */
GArchInstruction *dalvik35_read_instr_unused_ef(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f0'. */
GArchInstruction *dalvik35_read_instr_unused_f0(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f1'. */
GArchInstruction *dalvik35_read_instr_unused_f1(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f2'. */
GArchInstruction *dalvik35_read_instr_unused_f2(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f3'. */
GArchInstruction *dalvik35_read_instr_unused_f3(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f4'. */
GArchInstruction *dalvik35_read_instr_unused_f4(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f5'. */
GArchInstruction *dalvik35_read_instr_unused_f5(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f6'. */
GArchInstruction *dalvik35_read_instr_unused_f6(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f7'. */
GArchInstruction *dalvik35_read_instr_unused_f7(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f8'. */
GArchInstruction *dalvik35_read_instr_unused_f8(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-f9'. */
GArchInstruction *dalvik35_read_instr_unused_f9(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-fa'. */
GArchInstruction *dalvik35_read_instr_unused_fa(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-fb'. */
GArchInstruction *dalvik35_read_instr_unused_fb(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-fc'. */
GArchInstruction *dalvik35_read_instr_unused_fc(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-fd'. */
GArchInstruction *dalvik35_read_instr_unused_fd(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-fe'. */
GArchInstruction *dalvik35_read_instr_unused_fe(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);

/* Décode une instruction de type 'unused-ff'. */
GArchInstruction *dalvik35_read_instr_unused_ff(const GArchProcessor *, GProcContext *, const GBinContent *, vmpa2t *, GExeFormat *);



#endif  /* _PLUGINS_DALVIK_V35_OPCODES_OPCODES_H */
