
/* Chrysalide - Outil d'analyse de fichiers binaires
 * pool.h - prototypes pour l'extraction des informations issues des tables globales
 *
 * Copyright (C) 2010-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_DEX_POOL_H
#define _PLUGINS_DEX_POOL_H


#include <analysis/routine.h>
#include <glibext/delayed.h>


#include "class.h"
#include "format.h"
#include "method.h"



/* Charge en mémoire l'ensemble des chaînes du format DEX. */
bool load_all_dex_string_symbols(GDexFormat *, wgroup_id_t, GtkStatusStack *);

/* Compte le nombre de chaînes de caractères dans une table DEX. */
uint32_t count_strings_in_dex_pool(const GDexFormat *);

/* Extrait une chaîne de caractères d'une table DEX. */
const char *get_string_from_dex_pool(const GDexFormat *, uint32_t, mrange_t *);

/* Extrait un symbole de chaîne d'une table DEX. */
GBinSymbol *get_string_symbol_from_dex_pool(GDexFormat *, uint32_t);

/* Charge en mémoire l'ensemble des types du format DEX. */
bool load_all_dex_types(GDexFormat *, wgroup_id_t, GtkStatusStack *);

/* Compte le nombre de types dans une table DEX. */
uint32_t count_types_in_dex_pool(const GDexFormat *);

/* Extrait une représentation de type d'une table DEX. */
GDataType *get_type_from_dex_pool(GDexFormat *, uint32_t);

/* Charge en mémoire l'ensemble des champs du format DEX. */
bool load_all_dex_fields(GDexFormat *, wgroup_id_t, GtkStatusStack *);

/* Compte le nombre de champs dans une table DEX. */
uint32_t count_fields_in_dex_pool(const GDexFormat *);

/* Extrait une représentation de champ d'une table DEX. */
GBinVariable *get_field_from_dex_pool(GDexFormat *, uint32_t);

/* Compte le nombre de prototypes dans une table DEX. */
uint32_t count_prototypes_in_dex_pool(const GDexFormat *);

/* Extrait une représentation de routine d'une table DEX. */
GBinRoutine *get_prototype_from_dex_pool(GDexFormat *, uint32_t);

/* Charge toutes les classes listées dans le contenu binaire. */
bool load_all_dex_methods(GDexFormat *, wgroup_id_t, GtkStatusStack *);

/* Compte le nombre de méthodes dans une table DEX. */
uint32_t count_methods_in_dex_pool(const GDexFormat *);

/* Extrait une représentation de méthode d'une table DEX. */
GDexMethod *get_method_from_dex_pool(GDexFormat *, uint32_t);

/* Charge toutes les classes listées dans le contenu binaire. */
bool load_all_dex_classes(GDexFormat *, wgroup_id_t, GtkStatusStack *);

/* Extrait une représentation de classe d'une table DEX. */
GDexClass *get_class_from_dex_pool(GDexFormat *, uint32_t);



#endif  /* _PLUGINS_DEX_POOL_H */
