
/* Chrysalide - Outil d'analyse de fichiers binaires
 * helper_arm.h - prototypes pour la prise en compte des spécifités ARM pour la recherche de gadgets
 *
 * Copyright (C) 2015-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_ROPGADGETS_HELPER_ARM_H
#define _PLUGINS_ROPGADGETS_HELPER_ARM_H


#include <arch/processor.h>



/* Etablit une liste des contextes utiles à la recherche. */
size_t list_rop_contexts_for_arm(char ***);

/* Etablit un contexte utile et adapté à une recherche. */
GProcContext *get_rop_contexts_for_arm(const GArchProcessor *, size_t);

/* Définit les tailles possibles d'une instruction recherchée. */
const phys_t *setup_instruction_sizes_for_arm(size_t *);



#endif  /* _PLUGINS_ROPGADGETS_HELPER_ARM_H */
