
/* Chrysalide - Outil d'analyse de fichiers binaires
 * client.h - prototypes pour la connexion à un serveur Chrysalide
 *
 * Copyright (C) 2014-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _ANALYSIS_DB_CLIENT_H
#define _ANALYSIS_DB_CLIENT_H


#include <glib-object.h>
#include <stdbool.h>


#include "collection.h"



#define G_TYPE_DB_CLIENT            g_db_client_get_type()
#define G_DB_CLIENT(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_DB_CLIENT, GDbClient))
#define G_IS_DB_CLIENT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_DB_CLIENT))
#define G_DB_CLIENT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_DB_CLIENT, GDbClientClass))
#define G_IS_DB_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_DB_CLIENT))
#define G_DB_CLIENT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_DB_CLIENT, GDbClientClass))


/* Description de client à l'écoute (instance) */
typedef struct _GDbClient GDbClient;

/* Description de client à l'écoute (classe) */
typedef struct _GDbClientClass GDbClientClass;


/* Indique le type défini pour une description de client à l'écoute. */
GType g_db_client_get_type(void);

/* Prépare un client pour une connexion à une BD. */
GDbClient *g_db_client_new(char *, char *, const char *, const char *, GList *);

/* Démarre la connexion à la base de données interne. */
bool g_db_client_start_internal(GDbClient *);

/* Démarre la connexion à la base de données distante. */
bool g_db_client_start_remote(GDbClient *, const char *, unsigned short);

/* Arrête la connexion à la base de données. */
void g_db_client_stop(GDbClient *);

/* Identifie le canal de communication pour envois au serveur. */
int g_db_client_get_fd(GDbClient *);

/* Marque le canal de communication comme disponible. */
void g_db_client_put_fd(GDbClient *);

/* Effectue une demande de sauvegarde de l'état courant. */
bool g_db_client_save(GDbClient *);

/* Active les éléments en amont d'un horodatage donné. */
bool g_db_client_set_last_active(GDbClient *, timestamp_t);



#endif  /* _ANALYSIS_DB_CLIENT_H */
