
/* Chrysalide - Outil d'analyse de fichiers binaires
 * item-int.h - prototypes et définitions internes pour les bases d'éléments de collection
 *
 * Copyright (C) 2014-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _ANALYSIS_DB_ITEM_INT_H
#define _ANALYSIS_DB_ITEM_INT_H


#include "item.h"


#include <stdint.h>


#include "misc/rlestr.h"
#include "../binary.h"



/* Effectue la comparaison entre deux éléments de collection. */
typedef gint (* cmp_db_item_fc) (GDbItem *, GDbItem *, bool);

/* Importe la définition d'une base d'éléments pour collection. */
typedef bool (* unpack_db_item_fc) (GDbItem *, packed_buffer *);

/* Exporte la définition d'une base d'éléments pour collection. */
typedef bool (* pack_db_item_fc) (const GDbItem *, packed_buffer *);

/* Construit la description humaine d'un signet sur un tampon. */
typedef void (* build_item_label_fc) (GDbItem *);

/* Exécute un élément de collection sur un binaire. */
typedef bool (* run_item_fc) (GDbItem *, GLoadedBinary *);

/* Constitue les champs destinés à une insertion / modification. */
typedef bool (* prepare_db_statement) (const GDbItem *, bound_value **, size_t *);

/* Charge les valeurs utiles pour une localisation. */
typedef bool (* load_db_item_fc) (GDbItem *, const bound_value *, size_t);


/* Base d'un élément pour collection générique (instance) */
struct _GDbItem
{
    GObject parent;                         /* A laisser en premier        */

    timestamp_t created;                    /* Date de création            */
    timestamp_t timestamp;                  /* Date dernière activité      */

    rle_string author;                      /* Utilisateur d'origine       */
    rle_string tool;                        /* Eventuel outil automatique ?*/

    char *label;                            /* Représentation humaine      */

    bool is_volatile;                       /* Pas besoin de sauvegarde ?  */

};

/* Base d'un élément pour collection générique (classe) */
struct _GDbItemClass
{
    GObjectClass parent;                    /* A laisser en premier        */

    DBFeatures feature;                     /* Fonctionnalité représentée  */

    cmp_db_item_fc cmp;                     /* Comparaison entre éléments  */

    unpack_db_item_fc unpack;               /* Réception depuis le réseau  */
    pack_db_item_fc pack;                   /* Emission depuis le réseau   */

    build_item_label_fc build_label;        /* Construction de description */
    run_item_fc apply;                      /* Application de l'élément    */
    run_item_fc cancel;                     /* Retrait de l'élément        */

    prepare_db_statement prepare_stmt;      /* Préparation d'une requête   */
    load_db_item_fc load;                   /* Chargement à partir d'une BD*/

};


/* Définition du tronc commun pour les créations SQLite */
#define SQLITE_DB_ITEM_CREATE                   \
    SQLITE_TIMESTAMP_CREATE("created") ", "     \
    SQLITE_TIMESTAMP_CREATE("timestamp") ", "   \
    SQLITE_RLESTR_CREATE("author") ", "         \
    SQLITE_RLESTR_CREATE("tool") ", "           \
    SQLITE_RLESTR_CREATE("label")



#endif  /* _ANALYSIS_DB_ITEM_INT_H */
