
/* Chrysalide - Outil d'analyse de fichiers binaires
 * comment.h - prototypes pour la gestion des commentaires dans du texte
 *
 * Copyright (C) 2014-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _ANALYSIS_DB_ITEMS_COMMENT_H
#define _ANALYSIS_DB_ITEMS_COMMENT_H



#include <glib-object.h>


#include "../../../arch/vmpa.h"
#include "../../../glibext/gbufferline.h"



/* --------------------- ELABORATION D'UN ELEMENT DE COLLECTION --------------------- */


#define G_TYPE_DB_COMMENT               g_db_comment_get_type()
#define G_DB_COMMENT(obj)               (G_TYPE_CHECK_INSTANCE_CAST((obj), g_db_comment_get_type(), GDbComment))
#define G_IS_DB_COMMENT(obj)            (G_TYPE_CHECK_INSTANCE_TYPE((obj), g_db_comment_get_type()))
#define G_DB_COMMENT_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_DB_COMMENT, GDbCommentClass))
#define G_IS_DB_COMMENT_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_DB_COMMENT))
#define G_DB_COMMENT_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_DB_COMMENT, GDbCommentClass))


/* Commentaire à placer dans du texte quelconque (instance) */
typedef struct _GDbComment GDbComment;

/* Commentaire à placer dans du texte quelconque (classe) */
typedef struct _GDbCommentClass GDbCommentClass;


/* Indique le type défini pour un commentaire à l'intérieur d'une zone de texte. */
GType g_db_comment_get_type(void);

/* Crée une définition de commentaire dans une zone de texte. */
GDbComment *g_db_comment_new_inlined(const vmpa2t *, BufferLineFlags, bool);

/* Crée une définition de commentaire dans une zone de texte. */
GDbComment *g_db_comment_new_area(const vmpa2t *, BufferLineFlags, const char *, bool);

/* Fournit l'adresse associée à un commentaire. */
const vmpa2t *g_db_comment_get_address(const GDbComment *);

/* Fournit le commentaire associé à un commentaire. */
char *g_db_comment_get_text(GDbComment *);

/* Associe un contenu supplémentaire à un commentaire. */
void g_db_comment_add_dynamic_text(GDbComment *, char *);

/*  Associe un contenu statique supplémentaire à un commentaire. */
void g_db_comment_add_static_text(GDbComment *, const char *);



/* ---------------------- DEFINITION DE LA COLLECTION ASSOCIEE ---------------------- */


#define G_TYPE_COMMENT_COLLECTION               g_comment_collection_get_type()
#define G_COMMENT_COLLECTION(obj)               (G_TYPE_CHECK_INSTANCE_CAST((obj), g_comment_collection_get_type(), GCommentCollection))
#define G_IS_COMMENT_COLLECTION(obj)            (G_TYPE_CHECK_INSTANCE_TYPE((obj), g_comment_collection_get_type()))
#define G_COMMENT_COLLECTION_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_COMMENT_COLLECTION, GCommentCollectionClass))
#define G_IS_COMMENT_COLLECTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_COMMENT_COLLECTION))
#define G_COMMENT_COLLECTION_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_COMMENT_COLLECTION, GCommentCollectionClass))


/* Collection dédiée aux commentaires textuels (instance) */
typedef struct _GCommentCollection GCommentCollection;

/* Collection dédiée aux commentaires textuels (classe) */
typedef struct _GCommentCollectionClass GCommentCollectionClass;


/* Indique le type défini pour une collection de commentaires. */
GType g_comment_collection_get_type(void);

/* Crée une collection dédiée aux commentaires. */
GCommentCollection *g_comment_collection_new(void);



#endif  /* _ANALYSIS_DB_ITEMS_COMMENT_H */
