
/* Chrysalide - Outil d'analyse de fichiers binaires
 * switcher.h - prototypes pour la gestion des basculements d'affichage d'opérandes numériques
 *
 * Copyright (C) 2015-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _ANALYSIS_DB_ITEMS_SWITCHER_H
#define _ANALYSIS_DB_ITEMS_SWITCHER_H


#include <glib-object.h>


#include "../../../arch/immediate.h"
#include "../../../arch/instruction.h"



/* --------------------- ELABORATION D'UN ELEMENT DE COLLECTION --------------------- */


#define G_TYPE_DB_SWITCHER               g_db_switcher_get_type()
#define G_DB_SWITCHER(obj)               (G_TYPE_CHECK_INSTANCE_CAST((obj), g_db_switcher_get_type(), GDbSwitcher))
#define G_IS_DB_SWITCHER(obj)            (G_TYPE_CHECK_INSTANCE_TYPE((obj), g_db_switcher_get_type()))
#define G_DB_SWITCHER_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_DB_SWITCHER, GDbSwitcherClass))
#define G_IS_DB_SWITCHER_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_DB_SWITCHER))
#define G_DB_SWITCHER_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_DB_SWITCHER, GDbSwitcherClass))


/* Bascule d'affichage pour un opérande numérique (instance) */
typedef struct _GDbSwitcher GDbSwitcher;

/* Bascule d'affichage pour un opérande numérique (classe) */
typedef struct _GDbSwitcherClass GDbSwitcherClass;


/* Indique le type défini pour un signet à l'intérieur d'une zone de texte. */
GType g_db_switcher_get_type(void);

/* Crée une définition d'un signet dans une zone de texte. */
GDbSwitcher *g_db_switcher_new(GArchInstruction *, const GImmOperand *, ImmOperandDisplay);

#if 0
/* Fournit l'adresse associée à un signet. */
const vmpa2t *g_db_switcher_get_address(GDbSwitcher *);

/* Fournit le commentaire associé à un signet. */
const char *g_db_switcher_get_comment(const GDbSwitcher *);

/* Définit le commentaire associé à un signet. */
void g_db_switcher_set_comment(GDbSwitcher *, const char *);
#endif


/* ---------------------- DEFINITION DE LA COLLECTION ASSOCIEE ---------------------- */


#define G_TYPE_SWITCHER_COLLECTION               g_switcher_collection_get_type()
#define G_SWITCHER_COLLECTION(obj)               (G_TYPE_CHECK_INSTANCE_CAST((obj), g_switcher_collection_get_type(), GSwitcherCollection))
#define G_IS_SWITCHER_COLLECTION(obj)            (G_TYPE_CHECK_INSTANCE_TYPE((obj), g_switcher_collection_get_type()))
#define G_SWITCHER_COLLECTION_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_SWITCHER_COLLECTION, GSwitcherCollectionClass))
#define G_IS_SWITCHER_COLLECTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_SWITCHER_COLLECTION))
#define G_SWITCHER_COLLECTION_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_SWITCHER_COLLECTION, GSwitcherCollectionClass))


/* Collection dédiée aux basculements d'affichage (instance) */
typedef struct _GSwitcherCollection GSwitcherCollection;

/* Collection dédiée aux basculements d'affichage (classe) */
typedef struct _GSwitcherCollectionClass GSwitcherCollectionClass;


/* Indique le type défini pour une collection de basculements d'affichage. */
GType g_switcher_collection_get_type(void);

/* Crée une collection dédiée aux basculements d'affichage. */
GSwitcherCollection *g_switcher_collection_new(void);



#endif  /* _ANALYSIS_DB_ITEMS_SWITCH_H */
