
/* Chrysalide - Outil d'analyse de fichiers binaires
 * server.h - prototypes pour la mise en place d'un fournisseur d'éléments ajoutés
 *
 * Copyright (C) 2014-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _ANALYSIS_DB_SERVER_H
#define _ANALYSIS_DB_SERVER_H


#include <glib-object.h>
#include <stdbool.h>



#define G_TYPE_DB_SERVER            g_db_server_get_type()
#define G_DB_SERVER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_DB_SERVER, GDbServer))
#define G_IS_DB_SERVER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_DB_SERVER))
#define G_DB_SERVER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_DB_SERVER, GDbServerClass))
#define G_IS_DB_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_DB_SERVER))
#define G_DB_SERVER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_DB_SERVER, GDbServerClass))


/* Description de serveur à l'écoute (instance) */
typedef struct _GDbServer GDbServer;

/* Description de serveur à l'écoute (classe) */
typedef struct _GDbServerClass GDbServerClass;


/* Indique le type défini pour une description de serveur à l'écoute. */
GType g_db_server_get_type(void);

/* Prépare un serveur de BD pour les clients internes. */
GDbServer *g_db_server_new_internal(const char *, char *);

/* Prépare un serveur de BD pour les clients distants. */
GDbServer *g_db_server_new_remote(const char *);

/* Démarre le serveur de base de données. */
bool g_db_server_start(GDbServer *);

/* Arrête le serveur de base de données. */
void g_db_server_stop(GDbServer *);



#endif  /* _ANALYSIS_DB_SERVER_H */
