
/* Chrysalide - Outil d'analyse de fichiers binaires
 * type-int.h - prototypes pour la définition interne des types de données
 *
 * Copyright (C) 2012-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _ANALYSIS_TYPE_INT_H
#define _ANALYSIS_TYPE_INT_H


#include "type.h"



/* Décrit le type fourni sous forme de caractères. */
typedef GDataType * (* type_dup_fc) (const GDataType *);

/* Décrit le type fourni sous forme de caractères. */
typedef char * (* type_to_string_fc) (const GDataType *, bool);

/* Indique si le type est un pointeur. */
typedef bool (* type_is_pointer_fc) (const GDataType *);

/* Indique si le type est une référence. */
typedef bool (* type_is_reference_fc) (const GDataType *);



/* Description de type quelconque (instance) */
struct _GDataType
{
    GObject parent;                         /* A laisser en premier        */

    GDataType *namespace;                   /* Espace de noms / classe     */
    char *ns_sep;                           /* Séparateur d'éléments       */

    TypeQualifier qualifiers;               /* Eventuels qualificatifs     */

};

/* Description de type quelconque (classe) */
struct _GDataTypeClass
{
    GObjectClass parent;                    /* A laisser en premier        */

    bool handle_ns;                         /* Gestion au niveau de base ? */

    type_dup_fc dup;                        /* Copie d'instance existante  */
    type_to_string_fc to_string;            /* Conversion au format texte  */

    type_is_pointer_fc is_pointer;          /* Représentation de pointeur ?*/
    type_is_reference_fc is_reference;      /* Représentation de référence?*/

};



#endif  /* _ANALYSIS_TYPE_INT_H */
