
/* Chrysalide - Outil d'analyse de fichiers binaires
 * operand-int.h - prototypes pour la définition générique interne des opérandes
 *
 * Copyright (C) 2008-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _ARCH_OPERAND_INT_H
#define _ARCH_OPERAND_INT_H


#include "operand.h"



/* Compare un opérande avec un autre. */
typedef int (* operand_compare_fc) (const GArchOperand *, const GArchOperand *);

/* Traduit un opérande en version humainement lisible. */
typedef void (* operand_print_fc) (const GArchOperand *, GBufferLine *);

/* Construit un petit résumé concis de l'opérande. */
typedef char * (* operand_build_tooltip_fc) (const GArchOperand *, const GLoadedBinary *);

/* Charge un opérande depuis une mémoire tampon. */
typedef bool (* unserialize_operand_fc) (GArchOperand *, GAsmStorage *, GBinFormat *, packed_buffer *);

/* Sauvegarde un opérande dans une mémoire tampon. */
typedef bool (* serialize_operand_fc) (const GArchOperand *, GAsmStorage *, packed_buffer *);


/* Adjonction de rendu alternatif */
typedef struct _alt_rendering
{
    RenderingTagType tag;                   /* Type de rendu               */
    char text[0];                           /* Texte alternatif            */

} alt_rendering;


/* Définition générique d'un opérande d'architecture (instance) */
struct _GArchOperand
{
    GObject parent;                         /* A laisser en premier        */

    alt_rendering *alt_info;                /* Autre rendu éventuel        */

};


/* Définition générique d'un opérande d'architecture (classe) */
struct _GArchOperandClass
{
    GObjectClass parent;                    /* A laisser en premier        */

    operand_compare_fc compare;             /* Comparaison d'opérandes     */
    operand_print_fc print;                 /* Texte humain équivalent     */
    operand_build_tooltip_fc build_tooltip; /* Construction de description */

    unserialize_operand_fc unserialize;     /* Chargement depuis un tampon */
    serialize_operand_fc serialize;         /* Conservation dans un tampon */

};



#endif  /* _ARCH_OPERAND_INT_H */
