
/* Chrysalide - Outil d'analyse de fichiers binaires
 * undefined-int.h - prototypes pour la définition générique interne des instructions au comportement non défini
 *
 * Copyright (C) 2018 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _ARCH_UNDEFINED_INT_H
#define _ARCH_UNDEFINED_INT_H


#include "undefined.h"
#include "instruction-int.h"



/* Définition générique d'une instruction au comportement non défini (instance) */
struct _GUndefInstruction
{
    GArchInstruction parent;                /* A laisser en premier        */

    InstrBehaviorStatus status;             /* Conséquences réelles        */

};

/* Définition générique d'une instruction au comportement non défini (classe) */
struct _GUndefInstructionClass
{
    GArchInstructionClass parent;           /* A laisser en premier        */

};



#endif  /* _ARCH_UNDEFINED_INT_H */
