
/* Chrysalide - Outil d'analyse de fichiers binaires
 * collections.h - prototypes pour l'enregistrement et la diffusion des collections
 *
 * Copyright (C) 2014-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _CORE_COLLECTIONS_H
#define _CORE_COLLECTIONS_H


#include <glib-object.h>
#include <sqlite3.h>
#include <stdbool.h>
#include <stdint.h>



/* Enregistre un type d'élément à gérer par collection. */
uint32_t register_collection_type(GType);

/* Charge les définitions de collections "natives". */
bool load_hard_coded_collection_definitions(void);

/* Décharge toutes les définitions de collections. */
void unload_collection_definitions(void);

/* Construit un nouvel ensemble de collections. */
GList *create_collections_list(void);

/* Détruit un ensemble de collections. */
void delete_collections_list(GList **);



#endif  /* _ANALYSIS_DB_COLLECTION_H */
