
/* Chrysalide - Outil d'analyse de fichiers binaires
 * symbol-int.h - prototypes pour la définition interne des symboles dans un binaire
 *
 * Copyright (C) 2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _FORMAT_SYMBOL_INT_H
#define _FORMAT_SYMBOL_INT_H


#include "symbol.h"



/* Fournit une étiquette pour viser un symbole. */
typedef char * (* get_symbol_label_fc) (const GBinSymbol *);



/* Symbole d'exécutable (instance) */
struct _GBinSymbol
{
    GObject parent;                         /* A laisser en premier        */

    mrange_t range;                         /* Couverture mémoire          */
    SymbolType type;                        /* Type du symbole             */
    SymbolStatus status;                    /* Visibilité du symbole       */

    char *alt;                              /* Nom alternatif              */

};

/* Symbole d'exécutable (classe) */
struct _GBinSymbolClass
{
    GObjectClass parent;                    /* A laisser en premier        */

    get_symbol_label_fc get_label;          /* Obtention d'une étiquette   */

};



#endif  /* _FORMAT_SYMBOL_INT_H */
