
/* Chrysalide - Outil d'analyse de fichiers binaires
 * gwidthtracker.h - prototypes pour le suivi des largeurs associées à un ensemble de lignes
 *
 * Copyright (C) 2016-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _GLIBEXT_GWIDTHTRACKER_H
#define _GLIBEXT_GWIDTHTRACKER_H


#include <glib-object.h>
#include <stdbool.h>


#include "delayed.h"
#include "gbufferline.h"
#include "gdisplayoptions.h"



/* ---------------------------- RASSEMBLEMENT DE MESURES ---------------------------- */


/* gbuffercache.h : Tampon pour gestion de lignes optimisée (instance) */
typedef struct _GBufferCache GBufferCache;


#define G_TYPE_WIDTH_TRACKER            (g_width_tracker_get_type())
#define G_WIDTH_TRACKER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_WIDTH_TRACKER, GWidthTracker))
#define G_WIDTH_TRACKER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_WIDTH_TRACKER, GWidthTrackerClass))
#define G_IS_WIDTH_TRACKER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_WIDTH_TRACKER))
#define G_IS_WIDTH_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_WIDTH_TRACKER))
#define G_WIDTH_TRACKER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_WIDTH_TRACKER, GWidthTrackerClass))


/* Gestionnaire de largeurs associées aux lignes (instance) */
typedef struct _GWidthTracker GWidthTracker;

/* Gestionnaire de largeurs associées aux lignes (classe) */
typedef struct _GWidthTrackerClass GWidthTrackerClass;


/* Détermine le type du gestionnaire de largeurs associées aux lignes. */
GType g_width_tracker_get_type(void);

/* Crée un nouveau suivi de largeurs au sein de lignes. */
GWidthTracker *g_width_tracker_new(GBufferCache *);

/* Crée un nouveau suivi de largeurs au sein de lignes. */
GWidthTracker *g_width_tracker_new_restricted(const GWidthTracker *, size_t, size_t);

/* Prend acte d'un changement sur une ligne pour les largeurs. */
void g_width_tracker_update(GWidthTracker *, size_t);

/* Prend acte de l'ajout de lignes pour les largeurs. */
void g_width_tracker_update_added(GWidthTracker *, size_t, size_t);

/* Prend acte de la suppression de lignes pour les largeurs. */
void g_width_tracker_update_deleted(GWidthTracker *, size_t, size_t);

/* Calcule les largeurs requises par un ensemble de lignes. */
void g_width_tracker_build_initial_cache(GWidthTracker *, wgroup_id_t, GtkStatusStack *);

/* Fournit un bon résumé des largeurs en vigueur. */
const line_width_summary *g_width_tracker_get_width_summary(GWidthTracker *);

/* Fournit un résumé local des largeurs en vigueur. */
void g_width_tracker_get_local_width_summary(GWidthTracker *, size_t, line_width_summary *);

/* Fournit la largeur requise par une visualisation. */
gint g_width_tracker_get_width(GWidthTracker *, const GDisplayOptions *);

/* Fournit la largeur requise pour dépasser les marges gauches. */
gint g_width_tracker_get_margin(GWidthTracker *, const GDisplayOptions *);



#endif  /* _GLIBEXT_GWIDTHTRACKER_H */
