
/* Chrysalide - Outil d'analyse de fichiers binaires
 * panel-int.h - prototypes pour les définitions internes liées aux panneaux d'affichage
 *
 * Copyright (C) 2012-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GUI_PANELS_PANEL_INT_H
#define _GUI_PANELS_PANEL_INT_H


#include "panel.h"


#include <gtk/gtk.h>


#include "../editem-int.h"
#include "../../common/dllist.h"
#include "../../glibext/delayed.h"



/* ------------------------- COEUR DES PANNEAUX D'AFFICHAGE ------------------------- */


/* Place un panneau dans l'ensemble affiché. */
typedef void (* ack_dock_process_fc) (GPanelItem *);

/* Supprime un panneau de l'ensemble affiché. */
typedef void (* ack_undock_process_fc) (GPanelItem *);

/* Démarre l'actualisation du filtrage du contenu. */
typedef void (* update_filtered_fc) (GPanelItem *);


/* Elément réactif pour panneaux de l'éditeur (instance) */
struct _GPanelItem
{
    GEditorItem parent;                     /* A laisser en premier        */

    DL_LIST_ITEM(link);                     /* Maillon de liste chaînée    */

    PanelItemPersonality personality;       /* Nature de l'élément         */

    const char *lname;                      /* Description longue          */

    bool dock_at_startup;                   /* Recommandation au démarrage */
    char *path;                             /* Chemin vers la place idéale */

    bool docked;                            /* Panneau inscrusté ?         */

    char *filter;                           /* Eventuel filtre textuel     */

    /**
     * La gestion générique du constructeur repose sur quelques
     * prérequis quant à l'enregistrement de composants :
     *
     *    - "box" doit être le support de panneau à intégrer.
     *
     *    - pour les contenus actualisables, une pile de composants
     *      "stack" doit contenir un support "content" pour le
     *      contenu principal et un support "mask" qui prend le
     *      relais pendant les opérations de mise à jour.
     */

    GtkBuilder *builder;                    /* Constructeur utilisé        */

    cairo_surface_t *surface;               /* Copie d'écran préalable     */
    gdouble hadj_value;                     /* Sauvegarde de défilement #1 */
    gdouble vadj_value;                     /* Sauvegarde de défilement #2 */
    gint switched;                          /* Mémorise l'état de bascule  */

};

/* Elément réactif pour panneaux de l'éditeur (classe) */
struct _GPanelItemClass
{
    GEditorItemClass parent;                /* A laisser en premier        */

    bool unique;                            /* Panneau instanciable ?      */
    const char *bindings;                   /* Raccourci clavier éventuel  */

    bool can_search;                        /* Contenu fouillable ?        */

    ack_dock_process_fc ack_dock;           /* Prise en compte d'accroche  */
    ack_undock_process_fc ack_undock;       /* Prise en compte de décroche */

    update_filtered_fc update_filtered;     /* Lancement du filtrage       */

    wgroup_id_t gid;                        /* Groupe de travail dédié     */

    /* Signaux */

    void (* dock_request) (GPanelItem);
    void (* undock_request) (GPanelItem);

};


#define panels_list_add_tail(new, head) dl_list_add_tail(new, head, GPanelItem, link) 
#define panels_list_for_each(pos, head) dl_list_for_each(pos, head, GPanelItem, link) 


/* Charge les éléments graphiques du panneau via les ressources. */
GtkBuilder *g_panel_item_build(GPanelItem *, const char *);

/* Charge les éléments graphiques du panneau via les ressources. */
GtkBuilder *g_panel_item_build_full(GPanelItem *, const char *);



/* ---------------------- MECANISMES DE MISE A JOUR DE PANNEAU ---------------------- */


/* Obtient le groupe de travail dédié à une mise à jour. */
wgroup_id_t g_panel_item_get_group(const GPanelItem *);

/* Bascule l'affichage d'un panneau avant sa mise à jour. */
void g_panel_item_switch_to_updating_mask(GPanelItem *);

/* Bascule l'affichage d'un panneau après sa mise à jour. */
void g_panel_item_switch_to_updated_content(GPanelItem *);



#endif  /* _GUI_PANELS_PANEL_INT_H */
