
/* Chrysalide - Outil d'analyse de fichiers binaires
 * panel.h - prototypes pour la gestion des éléments réactifs spécifiques aux panneaux
 *
 * Copyright (C) 2012-2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GUI_PANELS_PANEL_H
#define _GUI_PANELS_PANEL_H


#include <stdbool.h>


#include "../editem.h"
#include "../../glibext/configuration.h"



#define G_TYPE_PANEL_ITEM            g_panel_item_get_type()
#define G_PANEL_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_PANEL_ITEM, GPanelItem))
#define G_IS_PANEL_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_PANEL_ITEM))
#define G_PANEL_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_PANEL_ITEM, GPanelItemClass))
#define G_IS_PANEL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_PANEL_ITEM))
#define G_PANEL_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_PANEL_ITEM, GPanelItemClass))


/* Elément réactif pour panneaux de l'éditeur (instance) */
typedef struct _GPanelItem GPanelItem;

/* Elément réactif pour panneaux de l'éditeur (classe) */
typedef struct _GPanelItemClass GPanelItemClass;


/* Types de panneaux pour éditeur */
typedef enum _PanelItemPersonality
{
    PIP_INVALID,                            /* Information non initialisée */

    PIP_SINGLETON,                          /* Instance unique             */
    PIP_BINARY_VIEW,                        /* Affichage d'un binaire      */
    PIP_OTHER,                              /* Reste du monde              */

    PIP_COUNT

} PanelItemPersonality;


/* Indique le type défini pour un élément destiné à un panneau. */
GType g_panel_item_get_type(void);

/* Crée un élément de panneau réactif. */
GPanelItem *g_panel_item_new(PanelItemPersonality, const char *, const char *, GtkWidget *, bool, const char *);

/* Met en place les bases de la configuration du panneau. */
bool gtk_panel_item_setup_configuration(const GPanelItem *, GGenConfig *);

/* Charge un panneau sur les bases de la configuration fournie. */
bool gtk_panel_item_apply_configuration(GPanelItem *, GGenConfig *);

/* Fournit une indication sur la personnalité du panneau. */
PanelItemPersonality gtk_panel_item_get_personality(const GPanelItem *);

/* Fournit le chemin d'accès à utiliser pour les encapsulations. */
const char *gtk_panel_item_get_path(const GPanelItem *);

/* Définit le chemin d'accès à utiliser pour les encapsulations. */
void gtk_panel_item_set_path(GPanelItem *, const char *);

/* Indique la définition d'un éventuel raccourci clavier. */
const char *gtk_panel_item_get_key_bindings(const GPanelItem *);

/* Place un panneau dans l'ensemble affiché. */
void g_panel_item_dock(GPanelItem *);

/* Définit si le composant repose sur un support de l'éditeur. */
void g_panel_item_set_dock_status(GPanelItem *, bool);

/* Indique si le composant repose sur un support de l'éditeur. */
bool g_panel_item_is_docked(const GPanelItem *);

/* Supprime un panneau de l'ensemble affiché. */
void g_panel_item_undock(GPanelItem *);



#endif  /* _GUI_PANELS_PANEL_H */
