#!/usr/bin/python
# -*- coding: utf-8 -*-

from .mitigations import ElfMitigations
from pychrysalide import PluginModule
from pychrysalide.core import log_message, LMT_INFO
from pychrysalide.format.elf import ElfFormat


class CheckSec(PluginModule):
    """Check for Elf mititgations."""


    def __init__(self):
        """Initialize the plugin for Chrysalide."""

        interface = {

            'name' : 'CheckSec',
            'desc' : 'Output the exploit mitigations compiled with a loaded binary',
            'version' : '0.1',

            'actions' : ( PluginModule.PGA_FORMAT_POST_ANALYSIS_ENDED, )

        }

        super(CheckSec, self).__init__(**interface)


    def handle_format_analysis(self, action, format, gid, status):
        """Get notified at the end of format analysis."""

        if type(format) == ElfFormat:

            m = ElfMitigations(format)

            msg = 'Elf mitigations: NX: <b>%s</b>  PIE: <b>%s</b>  RelRO: <b>%s</b>  Canary: <b>%s</b>' \
                  % (m._nx, m._pie, m._relro, m._canary)

            self.log_message(LMT_INFO, msg)
